/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Issue;
import ix.icore.Status;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.RefinementEvent;
import ix.ip2.AgendaItem;
import ix.ip2.ExpandHandler;
import ix.ip2.HandlerAction;
import ix.iplan.IPlan;
import ix.iplan.IPlanModelManager;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.match.MatchEnv;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class IPlanExpandHandler
extends ExpandHandler {
    protected IPlan iplan;

    public IPlanExpandHandler(IPlan iPlan) {
        super(iPlan);
        this.iplan = iPlan;
        this.actAgenda = iPlan.getController().getActivityAgenda();
        this.modelManager = (IPlanModelManager)iPlan.getModelManager();
        iPlan.getDomain().addDomainListener(this);
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addItemListener(new ExpandHandler.ItemListener());
        for (Refinement refinement : this.iplan.getDomain().getRefinements()) {
            MatchEnv matchEnv = this.matchRefinement(agendaItem, refinement);
            if (matchEnv == null) continue;
            agendaItem.addAction(new ExpandAction(agendaItem, refinement, matchEnv));
        }
    }

    public void refinementAdded(RefinementEvent refinementEvent) {
        Refinement refinement = refinementEvent.getRefinement();
        Debug.noteln("Expand Handler noting new ", (Object)refinement);
        this.iplan.getController().reconsiderHandler(this, refinement);
    }

    public void reviseHandlerActions(AgendaItem agendaItem, Object object) {
        Refinement refinement = (Refinement)object;
        MatchEnv matchEnv = this.matchRefinement(agendaItem, refinement);
        if (matchEnv == null) {
            return;
        }
        Debug.noteln("New expansion for", (Object)agendaItem);
        agendaItem.insertAction(new ExpandAction(agendaItem, refinement, matchEnv));
    }

    public HandlerAction makeManualExpandAction(AgendaItem agendaItem, Refinement refinement) {
        return new ManualExpandAction(agendaItem, refinement);
    }

    private class ManualExpandAction
    extends ExpandAction {
        ManualExpandAction(AgendaItem agendaItem, Refinement refinement) {
            super(agendaItem, refinement, new MatchEnv());
            this.shortDescription = "Expand as below";
        }

        public void handle(AgendaItem agendaItem) {
            this.do_expansion(agendaItem);
        }
    }

    private class ExpandAction
    extends HandlerAction {
        AgendaItem item;
        Refinement refinement;
        MatchEnv refinementMatchEnv;
        ListOfConstraint filters;
        List filterEnvs = Collections.EMPTY_LIST;

        ExpandAction(AgendaItem agendaItem, Refinement refinement, MatchEnv matchEnv) {
            this.item = agendaItem;
            this.refinement = refinement;
            this.refinementMatchEnv = matchEnv;
            this.filters = refinement.getFilterConstraints();
            this.shortDescription = "Expand using " + refinement.getName();
        }

        public boolean isStillValid() {
            if (this.item.isExpanded()) {
                return false;
            }
            this.refinementMatchEnv = IPlanExpandHandler.this.matchRefinement(this.item, this.refinement);
            return this.refinementMatchEnv != null;
        }

        public boolean canAlwaysBeTakenNow() {
            return true;
        }

        public boolean isReady() {
            return !this.item.isExpanded();
        }

        public void computeStatus() {
        }

        public void handle(AgendaItem agendaItem) {
            Debug.expect(this.isReady(), this + " asked to handle " + agendaItem + " when not ready");
            Debug.expect(agendaItem == this.item);
            this.do_expansion(agendaItem);
            agendaItem.fireAgendaItemEdited();
        }

        protected void do_expansion(AgendaItem agendaItem) {
            Object object;
            Debug.noteln("Expanding using", (Object)this.refinement);
            MatchEnv matchEnv = this.getInstantiationEnv();
            Debug.noteln("Using env", (Object)matchEnv);
            Debug.noteln("Filters", (Object)this.filters);
            agendaItem.expandOneLevel(this.refinement, matchEnv);
            IPlanExpandHandler.this.modelManager.applyEnv(matchEnv);
            Object object2 = Collect.iterator(agendaItem.getChildren());
            while (object2.hasNext()) {
                object = (AgendaItem)object2.next();
                IPlanExpandHandler.this.actAgenda.addItem((AgendaItem)object);
            }
            object2 = agendaItem.getRefinement().getIssues();
            object = Collect.iterator((Collection)object2);
            while (object.hasNext()) {
                Issue issue = (Issue)object.next();
                IPlanExpandHandler.this.iplan.getController().addIssue(issue);
            }
            object = agendaItem.getRefinement().getConstraints();
            if (object != null) {
                IPlanExpandHandler.this.iplan.getModelManager().addConstraints(agendaItem, (List)object);
            }
        }

        protected void adjustStatus(AgendaItem agendaItem) {
            if (agendaItem.getStatus() == Status.POSSIBLE) {
                agendaItem.setStatus(Collect.isEmpty(agendaItem.getChildren()) ? Status.COMPLETE : Status.EXECUTING);
            }
        }

        protected MatchEnv getInstantiationEnv() {
            if (!this.filters.isEmpty() && this.filterEnvs.size() == 1) {
                return (MatchEnv)this.filterEnvs.get(0);
            }
            return this.refinementMatchEnv;
        }
    }
}

