/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Variable;
import ix.icore.domain.Domain;
import ix.icore.domain.LinkedListOfNodeSpec;
import ix.icore.domain.ListOfNodeSpec;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.NodeSpecIterator;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainListener;
import ix.icore.domain.event.RefinementEvent;
import ix.iplan.Slip;
import ix.util.Debug;
import ix.util.DirectedGraph;
import ix.util.FanComposer;
import ix.util.Fn;
import ix.util.Function1;
import ix.util.Graphs;
import ix.util.Inf;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.match.Matcher;
import ix.util.xml.XML;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DomainAnalyser {
    protected Domain domain;
    protected boolean domainHasChanged = true;
    protected DirectedGraph refinementToDirectSuccessors;
    protected DirectedGraph refinementToReachableRefinements;
    protected DirectedGraph possibleConditionsTable;
    protected DirectedGraph possibleEffectsTable;
    protected DirectedGraph possibleConstraintsTable;
    protected MinFullExpandFinder minFullExpandFinder;
    protected Map possibleConditionsCache = new WeakHashMap();
    protected Map possibleEffectsCache = new WeakHashMap();
    protected Map possibleConstraintsCache = new WeakHashMap();
    protected Map minFullExpandSizeCache = new WeakHashMap();

    public DomainAnalyser(Domain domain) {
        Debug.expect(domain != null, "null domain");
        this.domain = domain;
        domain.checkConsistency();
        domain.addDomainListener(new DomainListener(){

            public void refinementAdded(RefinementEvent refinementEvent) {
                DomainAnalyser.this.domainHasChanged = true;
            }
        });
    }

    public void analyseIfNeeded() {
        if (this.domainHasChanged) {
            this.reset();
            this.analyse();
        }
    }

    protected void reset() {
        this.refinementToDirectSuccessors = null;
        this.refinementToReachableRefinements = null;
        this.possibleConditionsTable = null;
        this.possibleEffectsTable = null;
        this.possibleConstraintsTable = null;
        this.possibleConditionsCache.clear();
        this.possibleEffectsCache.clear();
        this.possibleConditionsCache.clear();
        this.domainHasChanged = true;
    }

    public void analyse() {
        Debug.noteln("Analyzing", (Object)this.domain);
        this.refinementToDirectSuccessors = this.buildRefinementSuccessorTable();
        this.refinementToReachableRefinements = Graphs.transitiveClosure(this.refinementToDirectSuccessors);
        DirectedGraph directedGraph = Graphs.makeReflexive(this.refinementToReachableRefinements);
        FanComposer fanComposer = new FanComposer(this.domain.getRefinements());
        fanComposer.apply(directedGraph);
        fanComposer.apply(Fn.accessor(Refinement.class, "getConditions"));
        this.possibleConditionsTable = Graphs.makeDirectedGraph(fanComposer.getResultMap());
        FanComposer fanComposer2 = new FanComposer(this.domain.getRefinements());
        fanComposer2.apply(directedGraph);
        fanComposer2.apply(Fn.accessor(Refinement.class, "getEffects"));
        this.possibleEffectsTable = Graphs.makeDirectedGraph(fanComposer2.getResultMap());
        FanComposer fanComposer3 = new FanComposer(this.domain.getRefinements());
        fanComposer3.apply(directedGraph);
        fanComposer3.apply(Fn.accessor(Refinement.class, "getOtherConstraints"));
        this.possibleConstraintsTable = Graphs.makeDirectedGraph(fanComposer3.getResultMap());
        this.minFullExpandFinder = new MinFullExpandFinder();
        this.domainHasChanged = false;
    }

    public Set getPossibleConditions(LList lList) {
        Set set = (Set)this.possibleConditionsCache.get(lList);
        if (set == null) {
            set = this.computePossibleConditions(lList);
            this.possibleConditionsCache.put(lList, set);
        }
        return set;
    }

    protected Set computePossibleConditions(LList lList) {
        FanComposer fanComposer = new FanComposer(Lisp.list(lList));
        fanComposer.apply(Fn.always(this.refinementsExpandingPattern(lList)));
        fanComposer.apply(this.possibleConditionsTable);
        Map map = fanComposer.getResultMap();
        Debug.expect(map.size() == 1);
        return (Set)map.get(lList);
    }

    public Set getPossibleConditions(PatternAssignment patternAssignment) {
        Set set = (Set)this.possibleConditionsCache.get(patternAssignment);
        if (set == null) {
            set = this.computePossibleConditions(patternAssignment);
            this.possibleConditionsCache.put(patternAssignment, set);
        }
        return set;
    }

    protected Set computePossibleConditions(PatternAssignment patternAssignment) {
        FanComposer fanComposer = new FanComposer(Lisp.list(patternAssignment));
        fanComposer.apply(Fn.always(this.refinementsForCondition(patternAssignment)));
        fanComposer.apply(this.possibleConditionsTable);
        Map map = fanComposer.getResultMap();
        Debug.expect(map.size() == 1);
        return (Set)map.get(patternAssignment);
    }

    public Set getPossibleEffects(LList lList) {
        Set set = (Set)this.possibleEffectsCache.get(lList);
        if (set == null) {
            set = this.computePossibleEffects(lList);
            this.possibleEffectsCache.put(lList, set);
        }
        return set;
    }

    protected Set computePossibleEffects(LList lList) {
        FanComposer fanComposer = new FanComposer(Lisp.list(lList));
        fanComposer.apply(Fn.always(this.refinementsExpandingPattern(lList)));
        fanComposer.apply(this.possibleEffectsTable);
        Map map = fanComposer.getResultMap();
        Debug.expect(map.size() == 1);
        return (Set)map.get(lList);
    }

    public Set getPossibleEffects(PatternAssignment patternAssignment) {
        Set set = (Set)this.possibleEffectsCache.get(patternAssignment);
        if (set == null) {
            set = this.computePossibleEffects(patternAssignment);
            this.possibleEffectsCache.put(patternAssignment, set);
        }
        return set;
    }

    protected Set computePossibleEffects(PatternAssignment patternAssignment) {
        FanComposer fanComposer = new FanComposer(Lisp.list(patternAssignment));
        fanComposer.apply(Fn.always(this.refinementsForCondition(patternAssignment)));
        fanComposer.apply(this.possibleEffectsTable);
        Map map = fanComposer.getResultMap();
        Debug.expect(map.size() == 1);
        return (Set)map.get(patternAssignment);
    }

    public Set getPossibleConstraints(LList lList) {
        Set set = (Set)this.possibleConstraintsCache.get(lList);
        if (set == null) {
            set = this.computePossibleConstraints(lList);
            this.possibleConstraintsCache.put(lList, set);
        }
        return set;
    }

    protected Set computePossibleConstraints(LList lList) {
        FanComposer fanComposer = new FanComposer(Lisp.list(lList));
        fanComposer.apply(Fn.always(this.refinementsExpandingPattern(lList)));
        fanComposer.apply(this.possibleConstraintsTable);
        Map map = fanComposer.getResultMap();
        Debug.expect(map.size() == 1);
        return (Set)map.get(lList);
    }

    public long getMinFullExpandSize(LList lList) {
        Long l = (Long)this.minFullExpandSizeCache.get(lList);
        if (l == null) {
            l = this.minFullExpandFinder.getMinFullExpandSize(lList);
            this.minFullExpandSizeCache.put(lList, l);
        }
        return l;
    }

    public long getMinFullExpandSize(PatternAssignment patternAssignment) {
        Long l = (Long)this.minFullExpandSizeCache.get(patternAssignment);
        if (l == null) {
            l = this.minFullExpandFinder.getMinFullExpandSize(patternAssignment);
            this.minFullExpandSizeCache.put(patternAssignment, l);
        }
        return l;
    }

    public DirectedGraph getUnexpandableNodes() {
        HashMap<Refinement, LinkedListOfNodeSpec> hashMap = new HashMap<Refinement, LinkedListOfNodeSpec>();
        for (Refinement refinement : this.domain.getRefinements()) {
            ListOfNodeSpec listOfNodeSpec = refinement.getNodes();
            if (listOfNodeSpec == null) continue;
            LinkedListOfNodeSpec linkedListOfNodeSpec = new LinkedListOfNodeSpec();
            NodeSpecIterator nodeSpecIterator = listOfNodeSpec.elements();
            while (nodeSpecIterator.hasNext()) {
                NodeSpec nodeSpec = nodeSpecIterator.next();
                if (!this.refinementsExpandingPattern(nodeSpec.getPattern()).isEmpty()) continue;
                linkedListOfNodeSpec.add(nodeSpec);
            }
            if (linkedListOfNodeSpec.isEmpty()) continue;
            hashMap.put(refinement, linkedListOfNodeSpec);
        }
        return Graphs.makeDirectedGraph(hashMap);
    }

    protected DirectedGraph buildRefinementSuccessorTable() {
        HashMap<Refinement, Set> hashMap = new HashMap<Refinement, Set>();
        for (Refinement refinement : this.domain.getRefinements()) {
            hashMap.put(refinement, this.directSuccessors(refinement));
        }
        return Graphs.makeDirectedGraph(hashMap);
    }

    protected Set directSuccessors(Refinement refinement) {
        Serializable serializable;
        Object object;
        Object object2;
        HashSet hashSet = new HashSet();
        ListOfNodeSpec listOfNodeSpec = refinement.getNodes();
        if (listOfNodeSpec != null) {
            object2 = listOfNodeSpec.elements();
            while (object2.hasNext()) {
                object = object2.next();
                serializable = ((NodeSpec)object).getPattern();
                hashSet.addAll(this.refinementsExpandingPattern((LList)serializable));
            }
        }
        object2 = refinement.getConditions();
        object = object2.iterator();
        while (object.hasNext()) {
            serializable = (PatternAssignment)object.next();
            hashSet.addAll(this.refinementsForCondition((PatternAssignment)serializable));
        }
        return hashSet;
    }

    protected Set refinementsExpandingPattern(LList lList) {
        HashSet<Refinement> hashSet = new HashSet<Refinement>();
        for (Refinement refinement : this.domain.getRefinements()) {
            if (!DomainAnalyser.match(refinement.getPattern(), lList)) continue;
            hashSet.add(refinement);
        }
        return hashSet;
    }

    protected Set refinementsForCondition(PatternAssignment patternAssignment) {
        HashSet<Refinement> hashSet = new HashSet<Refinement>();
        if (!Slip.isAchievableCond(patternAssignment.getPattern(), this.domain)) {
            return hashSet;
        }
        for (Refinement refinement : this.domain.getRefinements()) {
            for (PatternAssignment patternAssignment2 : refinement.getEffects()) {
                if (!Slip.canBeUsedForEffect(patternAssignment2.getPattern(), refinement) || !DomainAnalyser.match(patternAssignment2.getPattern(), patternAssignment.getPattern()) || !DomainAnalyser.match(patternAssignment2.getValue(), patternAssignment.getValue())) continue;
                hashSet.add(refinement);
            }
        }
        return hashSet;
    }

    public boolean haveCommonPatterns(Collection collection, Collection collection2) {
        for (PatternAssignment patternAssignment : collection) {
            for (PatternAssignment patternAssignment2 : collection2) {
                if (!DomainAnalyser.match(patternAssignment.getPattern(), patternAssignment2.getPattern())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean mightSatisfy(PatternAssignment patternAssignment, PatternAssignment patternAssignment2) {
        return DomainAnalyser.match(patternAssignment.getPattern(), patternAssignment2.getPattern()) && DomainAnalyser.match(patternAssignment.getValue(), patternAssignment2.getValue());
    }

    public boolean mightSatisfy(PatternAssignment patternAssignment, Collection collection) {
        for (PatternAssignment patternAssignment2 : collection) {
            if (!this.mightSatisfy(patternAssignment, patternAssignment2)) continue;
            return true;
        }
        return false;
    }

    public static boolean match(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object instanceof ItemVar || object instanceof Variable) {
            return true;
        }
        if (object2 instanceof ItemVar || object2 instanceof Variable) {
            return true;
        }
        if (object instanceof Cons) {
            if (object2 instanceof Cons) {
                LList lList;
                LList lList2 = (LList)object;
                for (lList = (LList)object2; lList2 != Lisp.NIL && lList != Lisp.NIL; lList2 = lList2.cdr(), lList = lList.cdr()) {
                    Object object3 = lList2.car();
                    if (object3 == Matcher.REST) {
                        return true;
                    }
                    if (DomainAnalyser.match(object3, lList.car())) continue;
                    return false;
                }
                return lList2 == lList;
            }
            return false;
        }
        return object.equals(object2);
    }

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.processCommandLineArguments(stringArray);
        String string = Parameters.getParameter("domain");
        Domain domain = XML.readObject(Domain.class, string);
        DomainAnalyser domainAnalyser = new DomainAnalyser(domain);
        domainAnalyser.analyse();
        DomainAnalyser.printGraph("Successor table:", domainAnalyser.refinementToDirectSuccessors);
        DomainAnalyser.printGraph("Reach table:", domainAnalyser.refinementToReachableRefinements);
        DomainAnalyser.printGraph("Possible effects:", domainAnalyser.possibleEffectsTable);
        DomainAnalyser.printGraph("Possible constraints:", domainAnalyser.possibleConstraintsTable);
        DomainAnalyser.printCollection("Unreachable refinements:", Graphs.minimalElements(domainAnalyser.refinementToDirectSuccessors));
        DomainAnalyser.printGraph("Unexpandable nodes:", domainAnalyser.getUnexpandableNodes());
        DomainAnalyser.println("Min full expansion sizes:");
        Map map = domainAnalyser.minFullExpandFinder.makeMinFullExpandTable();
        for (Object k : map.keySet()) {
            DomainAnalyser.println("   " + k + ": " + Inf.asString((Long)map.get(k)));
        }
        if (Parameters.getBoolean("ask-for-conditions")) {
            domainAnalyser.askForConditionsLoop();
        }
        if (Parameters.getBoolean("ask-for-effects")) {
            domainAnalyser.askForEffectsLoop();
        }
    }

    void askForConditionsLoop() {
        this.askLoop("conditions", new Function1(){

            public Object funcall(Object object) {
                return object instanceof LList ? DomainAnalyser.this.getPossibleConditions((LList)object) : DomainAnalyser.this.getPossibleConditions((PatternAssignment)object);
            }
        });
    }

    void askForEffectsLoop() {
        this.askLoop("effects", new Function1(){

            public Object funcall(Object object) {
                return object instanceof LList ? DomainAnalyser.this.getPossibleEffects((LList)object) : DomainAnalyser.this.getPossibleEffects((PatternAssignment)object);
            }
        });
    }

    void askLoop(String string, Function1 function1) {
        DomainAnalyser.println("Looking for", string);
        DomainAnalyser.println("Input can be a pattern or pattern = value.");
        DomainAnalyser.println("A pattern should not have parens around it.");
        while (true) {
            try {
                while (true) {
                    Serializable serializable;
                    String string2;
                    if ((string2 = Util.askLine("Input:")).equals("bye")) {
                        return;
                    }
                    if (string2.indexOf("=") >= 0) {
                        String[] stringArray = Strings.breakAtFirst("=", string2);
                        serializable = new PatternAssignment(Lisp.elementsFromString(stringArray[0]), Lisp.readFromString(stringArray[1]));
                    } else {
                        serializable = Lisp.elementsFromString(string2);
                    }
                    DomainAnalyser.println("Query:", serializable);
                    DomainAnalyser.printCollection(string, (Collection)function1.funcall(serializable));
                }
            }
            catch (Throwable throwable) {
                Debug.noteException(throwable);
                continue;
            }
            break;
        }
    }

    static void printGraph(String string, DirectedGraph directedGraph) {
        DomainAnalyser.println(string);
        List list = DomainAnalyser.sortCollection(directedGraph.getAllNodes());
        for (Object e : list) {
            DomainAnalyser.println("   ", e);
            List list2 = DomainAnalyser.sortCollection(directedGraph.getSuccessors(e));
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                DomainAnalyser.println("      ", iterator.next());
            }
            DomainAnalyser.println("");
        }
    }

    static void printCollection(String string, Collection collection) {
        DomainAnalyser.println(string);
        Iterator iterator = DomainAnalyser.sortCollection(collection).iterator();
        while (iterator.hasNext()) {
            DomainAnalyser.println("   ", iterator.next());
        }
        DomainAnalyser.println("");
    }

    static List sortCollection(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        if (!arrayList.isEmpty() && arrayList.get(0) instanceof Refinement) {
            Collections.sort(arrayList, new Refinement.NameComparator());
        }
        return arrayList;
    }

    private static void print(String string) {
        System.out.print(string);
    }

    private static void println(String string) {
        System.out.println(string);
    }

    private static void println(String string, Object object) {
        System.out.println(string + " " + object);
    }

    class MinFullExpandFinder {
        Map sizes = new IdentityHashMap();
        Long START_MARK = new Long(-1L);

        MinFullExpandFinder() {
        }

        long getMinFullExpandSize(LList lList) {
            Set set = DomainAnalyser.this.refinementsExpandingPattern(lList);
            return this.minExpandSize(set);
        }

        long getMinFullExpandSize(PatternAssignment patternAssignment) {
            Set set = DomainAnalyser.this.refinementsForCondition(patternAssignment);
            return this.minExpandSize(set);
        }

        Map makeMinFullExpandTable() {
            for (Object e : DomainAnalyser.this.domain.getRefinements()) {
                this.findSize((Refinement)e);
            }
            return this.sizes;
        }

        private void findSize(Refinement refinement) {
            Long l = (Long)this.sizes.get(refinement);
            if (l == this.START_MARK) {
                this.sizes.put(refinement, Long.MAX_VALUE);
            } else if (l == null) {
                this.sizes.put(refinement, this.START_MARK);
                ListOfNodeSpec listOfNodeSpec = refinement.getNodes();
                if (listOfNodeSpec == null || listOfNodeSpec.isEmpty()) {
                    this.sizes.put(refinement, new Long(0L));
                    return;
                }
                long l2 = listOfNodeSpec.size();
                for (Object e : listOfNodeSpec) {
                    NodeSpec nodeSpec = (NodeSpec)e;
                    l2 = Inf.add(l2, this.getMinFullExpandSize(nodeSpec.getPattern()));
                }
                this.sizes.put(refinement, l2);
            }
        }

        private long minExpandSize(Set set) {
            if (set.isEmpty()) {
                return 0L;
            }
            long l = Long.MAX_VALUE;
            for (Object e : set) {
                Refinement refinement = (Refinement)e;
                this.findSize(refinement);
                long l2 = (Long)this.sizes.get(refinement);
                if (l2 >= l) continue;
                l = l2;
            }
            return l;
        }
    }
}

