/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.IXAgentExtension;
import ix.icore.domain.ListOfPatternAssignment;
import ix.icore.process.event.ProcessStatusEvent;
import ix.ip2.AgendaItem;
import ix.ip2.Ip2;
import ix.ip2.NullStateViewer;
import ix.ip2.SyncState;
import ix.util.Debug;
import ix.util.StableHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SyncStateServer
extends SyncState
implements IXAgentExtension {
    protected Set clients = new TreeSet();

    public SyncStateServer(Ip2 ip2) {
        super(ip2);
    }

    public void installExtension() {
        this.ip2.getController().addActivityHandler(new SyncStateServerHandler(this.ip2));
        this.ip2.addStartupHook(new StartupHook());
        this.ip2.addResetHook(new ResetHook());
    }

    protected void sendToClients(SyncState.ClientOperation clientOperation) {
        Iterator iterator = this.clients.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                this.send(string, clientOperation);
            }
            catch (Exception exception) {
                Debug.displayException("Will drop " + string + " as a sync-state client", exception);
                iterator.remove();
                Debug.noteln("Sync-state clients", (Object)this.clients);
            }
        }
    }

    protected void handleOperation(SyncState.ServerOperation serverOperation) {
        Debug.noteln("Sync-state server handing " + serverOperation + " for " + serverOperation.getClientName());
        serverOperation.run(this);
    }

    protected void handle(SyncState.RegisterClient registerClient) {
        String string = registerClient.getClientName();
        if (this.clients.contains(string)) {
            Debug.noteln("Sync-state server will re-register", (Object)string);
            this.clients.remove(string);
        }
        ListOfPatternAssignment listOfPatternAssignment = registerClient.getDelta();
        this.ip2.getIp2ModelManager().handleEffects(listOfPatternAssignment);
        this.registerClient(string);
    }

    protected void registerClient(String string) {
        Debug.noteln("Sync-state server registering", (Object)string);
        Debug.expect(!this.clients.contains(string), "Registering twice?");
        this.clients.add(string);
        Map map = this.ip2.getIp2ModelManager().getWorldStateMap();
        map = new StableHashMap(map);
        this.send(string, new SyncState.ServerFullState(map));
    }

    protected void registerIfNew(String string) {
        if (!this.clients.contains(string)) {
            Debug.noteln("Sync-state server Treating as old client", (Object)string);
            this.registerClient(string);
        }
    }

    public void handle(SyncState.ClientStateChange clientStateChange) {
        ListOfPatternAssignment listOfPatternAssignment = clientStateChange.getDelta();
        this.ip2.getIp2ModelManager().handleEffects(listOfPatternAssignment);
        this.registerIfNew(clientStateChange.getClientName());
    }

    public void handle(SyncState.ClientStateDeletion clientStateDeletion) {
        ListOfPatternAssignment listOfPatternAssignment = clientStateDeletion.getDelta();
        this.deletionUtility(listOfPatternAssignment);
        this.registerIfNew(clientStateDeletion.getClientName());
    }

    public class SyncStateServerHandler
    extends SyncState.SyncStateHandler {
        public SyncStateServerHandler(Ip2 ip2) {
            super(ip2, "Synchronized-state server");
        }

        public void handle(AgendaItem agendaItem) {
            SyncStateServer.this.handleOperation((SyncState.ServerOperation)this.getOperation(agendaItem));
        }
    }

    protected class ProcessListener
    extends NullStateViewer {
        protected ProcessListener() {
        }

        public void stateChange(ProcessStatusEvent processStatusEvent, Map map) {
            if (!SyncStateServer.this.ip2.isReloadingViewers()) {
                SyncStateServer.this.sendToClients(new SyncState.ServerStateChange(map));
            }
        }

        public void stateDeletion(ProcessStatusEvent processStatusEvent, Map map) {
            if (!SyncStateServer.this.ip2.isReloadingViewers()) {
                SyncStateServer.this.sendToClients(new SyncState.ServerStateDeletion(map));
            }
        }
    }

    protected class ResetHook
    implements Runnable {
        protected ResetHook() {
        }

        public void run() {
        }
    }

    protected class StartupHook
    implements Runnable {
        protected StartupHook() {
        }

        public void run() {
            SyncStateServer.this.ip2.getModelManager().addProcessStatusListener(new ProcessListener());
        }
    }
}

