/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.Issue;
import ix.icore.Report;
import ix.icore.TaskItem;
import ix.icore.process.ProcessModelManager;
import ix.ip2.ActivityAgenda;
import ix.ip2.ActivityHandler;
import ix.ip2.ActivityItem;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.IssueAgenda;
import ix.ip2.IssueHandler;
import ix.ip2.IssueItem;
import ix.ip2.ItemHandler;
import ix.ip2.WaitForReportsActivity;
import ix.ip2.WaitForReportsItem;
import ix.ip2.event.AgendaListener;
import ix.ip2.event.ControllerListener;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Predicate1;
import java.util.LinkedList;
import java.util.List;

public class PanelController {
    private Ip2 ip2;
    private Ip2ModelManager modelManager;
    private List listeners = new LinkedList();
    private ActivityAgenda activities;
    private Agenda issues;
    protected Object validityCheckReason = null;

    public PanelController(Ip2 ip2) {
        this.ip2 = ip2;
        this.activities = this.makeActivityAgenda();
        this.issues = this.makeIssueAgenda();
    }

    protected ActivityAgenda makeActivityAgenda() {
        return new ActivityAgenda(this);
    }

    protected IssueAgenda makeIssueAgenda() {
        return new IssueAgenda(this);
    }

    public void connectTo(ProcessModelManager processModelManager) {
        this.modelManager = (Ip2ModelManager)processModelManager;
        processModelManager.addProcessStatusListener(this.activities);
        processModelManager.addProcessStatusListener(this.issues);
    }

    public void reset() {
        this.activities.reset();
        this.issues.reset();
    }

    public void clearModel() {
        this.activities.clear();
        this.issues.clear();
    }

    public Ip2 getAgent() {
        return this.ip2;
    }

    public Ip2ModelManager getModelManager() {
        return this.modelManager;
    }

    public Agenda getActivityAgenda() {
        return this.activities;
    }

    public Agenda getIssueAgenda() {
        return this.issues;
    }

    public Agenda getAgenda(TaskItem taskItem) {
        if (taskItem instanceof Issue) {
            return this.issues;
        }
        if (taskItem instanceof Activity) {
            return this.activities;
        }
        throw new ConsistencyException("Not an issue or activity", taskItem);
    }

    public void addAboutInfo(List list) {
        this.addAboutHandlersInfo(list, "Issue", this.issues.getItemHandlers());
        this.addAboutHandlersInfo(list, "Activity", this.activities.getItemHandlers());
    }

    private void addAboutHandlersInfo(List list, String string, List list2) {
        list.add("");
        if (list2.isEmpty()) {
            list.add(string + " handlers: none");
        } else {
            list.add(string + " handlers:");
            for (ItemHandler itemHandler : list2) {
                list.add("   " + itemHandler + (itemHandler.isAutomatic() ? " - Automatic" : ""));
            }
        }
    }

    public ActivityItem addActivity(Activity activity) {
        ActivityItem activityItem;
        if (activity instanceof WaitForReportsActivity) {
            activityItem = new WaitForReportsItem(activity);
            this.activities.addItem(activityItem);
        } else {
            activityItem = new ActivityItem(activity);
            this.activities.addItem(activityItem);
        }
        return activityItem;
    }

    public IssueItem addIssue(Issue issue) {
        IssueItem issueItem = new IssueItem(issue);
        this.issues.addItem(issueItem);
        return issueItem;
    }

    public boolean canHandleAutomatically(TaskItem taskItem) {
        Debug.noteln("Can handle automatically?", (Object)taskItem);
        return this.getAgenda(taskItem).canHandleAutomatically(taskItem);
    }

    public void handleAutomatically(TaskItem taskItem) {
        Debug.noteln("Automatically handling", (Object)taskItem);
        this.getAgenda(taskItem).handleAutomatically(taskItem);
    }

    public void addHandledItem(AgendaItem agendaItem) {
        this.getAgenda(agendaItem.getAbout()).addItem(agendaItem);
    }

    public void newReport(Report report) {
        if (!this.issues.acceptReport(report) && !this.activities.acceptReport(report)) {
            throw new ConsistencyException("Failed to accept " + report);
        }
    }

    public boolean wantsReport(Report report) {
        return this.issues.wantsReport(report) || this.activities.wantsReport(report);
    }

    public void addHandler(ItemHandler itemHandler) {
        if (itemHandler instanceof IssueHandler) {
            this.addIssueHandler(itemHandler);
        } else if (itemHandler instanceof ActivityHandler) {
            this.addActivityHandler(itemHandler);
        } else {
            this.addItemHandler(itemHandler);
        }
    }

    public void addActivityHandler(ItemHandler itemHandler) {
        this.activities.addItemHandler(itemHandler);
    }

    public void addIssueHandler(ItemHandler itemHandler) {
        this.issues.addItemHandler(itemHandler);
    }

    public void addItemHandler(ItemHandler itemHandler) {
        this.activities.addItemHandler(itemHandler);
        this.issues.addItemHandler(itemHandler);
    }

    public ItemHandler findHandler(Predicate1 predicate1) {
        Object object = Collect.findIf(this.issues.getItemHandlers(), predicate1);
        if (object == null) {
            object = Collect.findIf(this.activities.getItemHandlers(), predicate1);
        }
        return (ItemHandler)object;
    }

    public void checkActionValidity(ItemHandler itemHandler, Object object) {
        if (object != null && object == this.validityCheckReason) {
            Debug.noteln("Skipping check for", (Object)itemHandler);
            return;
        }
        this.validityCheckReason = object;
        Debug.noteln("Controller asked to check action validity by", (Object)itemHandler);
        Debug.noteln("For reason", object);
        if (this.issues.handlers.contains(itemHandler)) {
            this.issues.checkActionValidity(itemHandler, object);
        }
        if (this.activities.handlers.contains(itemHandler)) {
            this.activities.checkActionValidity(itemHandler, object);
        }
    }

    public void reconsiderHandler(ItemHandler itemHandler, Object object) {
        Debug.noteln("Controller asked to reconsider", (Object)itemHandler);
        Debug.noteln("For reason", object);
        if (this.issues.handlers.contains(itemHandler)) {
            this.issues.reconsiderHandler(itemHandler, object);
        }
        if (this.activities.handlers.contains(itemHandler)) {
            this.activities.reconsiderHandler(itemHandler, object);
        }
    }

    public void addActivityListener(AgendaListener agendaListener) {
        this.activities.addAgendaListener(agendaListener);
        agendaListener.setAgendaManager(this.activities);
    }

    public void addIssueListener(AgendaListener agendaListener) {
        this.issues.addAgendaListener(agendaListener);
        agendaListener.setAgendaManager(this.issues);
    }

    public void addControllerListener(ControllerListener controllerListener) {
        this.listeners.add(controllerListener);
    }
}

