/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.ListOfConstraint;
import ix.ip2.ActionUnreadyReason;
import ix.ip2.ActivityHandler;
import ix.ip2.AgendaItem;
import ix.ip2.BindingViewer;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.UnsatisfiedConditionsUnreadyReason;
import ix.ip2.event.AgendaItemAdapter;
import ix.ip2.event.AgendaItemEvent;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.match.MatchEnv;
import ix.util.match.SimpleMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConditionHandler
extends ActivityHandler {
    protected Ip2 ip2;
    protected Ip2ModelManager modelManager;

    public ConditionHandler(Ip2 ip2) {
        super("Satisfy conditions");
        this.ip2 = ip2;
        this.modelManager = (Ip2ModelManager)ip2.getModelManager();
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        return true;
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        if (this.isUsefulFor(agendaItem)) {
            agendaItem.addAction(new SatisfyAction(agendaItem));
        } else {
            agendaItem.addItemListener(new ItemListener());
        }
    }

    protected boolean isUsefulFor(AgendaItem agendaItem) {
        return agendaItem.isExpanded() && agendaItem.getHandledBy() == null && !Collect.isEmpty(this.modelManager.getNodeConditions(agendaItem));
    }

    public void reviseHandlerActions(AgendaItem agendaItem, Object object) {
        if (agendaItem.findAction(SatisfyAction.class) == null) {
            this.addHandlerActions(agendaItem);
        }
    }

    class SatisfyAction
    extends HandlerAction {
        AgendaItem item;
        MatchEnv env = SimpleMatcher.emptyEnv;
        ListOfConstraint filters;
        List filterEnvs = Collections.EMPTY_LIST;
        Set unboundVariables;

        SatisfyAction(AgendaItem agendaItem) {
            this.shortDescription = "Satisfy conditions";
            this.item = agendaItem;
            this.filters = ConditionHandler.this.modelManager.getNodeConditions(agendaItem);
        }

        public boolean isReady() {
            return this.filters.isEmpty() || !this.filterEnvs.isEmpty();
        }

        public void computeStatus() {
            if (!this.filters.isEmpty()) {
                this.filterEnvs = ConditionHandler.this.modelManager.evalFilters(this.filters, this.env);
            }
        }

        public ActionUnreadyReason getUnreadyReason() {
            ListOfConstraint listOfConstraint = ConditionHandler.this.modelManager.testFilters(this.filters, this.env);
            return new UnsatisfiedConditionsUnreadyReason(this, this.filters, listOfConstraint, this.env);
        }

        public void handle(AgendaItem agendaItem) {
            Debug.expect(agendaItem == this.item);
            ListOfConstraint listOfConstraint = this.filters;
            List list = ConditionHandler.this.modelManager.reevaluateFilters(listOfConstraint);
            Debug.expect(!list.isEmpty(), "Cannot match filter conditions " + listOfConstraint);
            Set set = Variable.varsAnywhereIn(listOfConstraint);
            Set set2 = Variable.unboundVarsIn(set);
            Debug.noteln("Cond vars", (Object)set);
            Debug.noteln("Unbound", (Object)set2);
            if (set2.isEmpty()) {
                this.adjustStatus(agendaItem);
                return;
            }
            this.unboundVariables = set2;
            BindingViewer bindingViewer = new BindingViewer(ConditionHandler.this.ip2, set2){

                public void handleBindings(Map map) {
                    if (map != null) {
                        SatisfyAction.this.bind(map);
                    }
                }
            };
        }

        protected void bind(Map map) {
            try {
                ConditionHandler.this.modelManager.bindVariables(map);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Debug.displayException(illegalArgumentException);
            }
            Set set = Variable.unboundVarsIn(this.unboundVariables);
            Debug.noteln("Still unbound", (Object)set);
            if (set.isEmpty()) {
                this.adjustStatus(this.item);
            } else {
                this.item.setHandledBy(null);
            }
        }

        protected void adjustStatus(AgendaItem agendaItem) {
            agendaItem.setStatus(Collect.isEmpty(agendaItem.getChildren()) ? Status.COMPLETE : Status.EXECUTING);
        }
    }

    protected class ItemListener
    extends AgendaItemAdapter {
        public void agendaItemEdited(AgendaItemEvent agendaItemEvent) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (ConditionHandler.this.isUsefulFor(agendaItem)) {
                ConditionHandler.this.ip2.getController().reconsiderHandler(ConditionHandler.this, agendaItemEvent);
            }
        }
    }
}

