/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.ListOfConstraint;
import ix.icore.process.PNodeEnd;
import ix.ip2.ActionUnreadyReason;
import ix.ip2.ActivityItem;
import ix.ip2.AgendaItem;
import ix.ip2.BindingViewer;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.SimpleCompletionHandler;
import ix.ip2.SimpleUnreadyReason;
import ix.ip2.UnsatisfiedConditionsUnreadyReason;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.match.MatchEnv;
import ix.util.match.SimpleMatcher;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionHandler
extends SimpleCompletionHandler {
    Ip2 ip2;
    Ip2ModelManager modelManager;

    public CompletionHandler(Ip2 ip2) {
        this.ip2 = ip2;
        this.modelManager = ip2.getIp2ModelManager();
    }

    @Override
    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addAction(new NoAction(agendaItem));
        agendaItem.addAction(new DoneAction(agendaItem));
        agendaItem.addAction(new NotApplicableAction(agendaItem));
    }

    private static List<PNodeEnd> allWithoutStatusExcept(PNodeEnd pNodeEnd, List<PNodeEnd> list, Status status) {
        LinkedList<PNodeEnd> linkedList = new LinkedList<PNodeEnd>();
        for (PNodeEnd pNodeEnd2 : list) {
            if (pNodeEnd2 == pNodeEnd || pNodeEnd2.getStatus() == status) continue;
            linkedList.add(pNodeEnd2);
        }
        return linkedList;
    }

    public class DoneAction
    extends HandlerAction {
        AgendaItem item;
        boolean wasExpanded;
        String expandedDescr;
        MatchEnv env = SimpleMatcher.emptyEnv;
        ListOfConstraint filters;
        List filterEnvs = Collections.EMPTY_LIST;
        Set unboundVariables;

        public DoneAction(AgendaItem agendaItem) {
            this(agendaItem, "Done", "Start");
        }

        public DoneAction(AgendaItem agendaItem, String string, String string2) {
            this.shortDescription = string;
            this.item = agendaItem;
            this.expandedDescr = string2;
            this.wasExpanded = agendaItem.isExpanded();
            if (this.wasExpanded && !agendaItem.getChildren().isEmpty()) {
                this.shortDescription = string2;
            }
            this.filters = CompletionHandler.this.modelManager.getNodeConditions(agendaItem);
        }

        public boolean isReady() {
            if (this.item.isExpanded() != this.wasExpanded) {
                Debug.expect(this.item.isExpanded());
                this.wasExpanded = true;
                this.filters = CompletionHandler.this.modelManager.getNodeConditions(this.item);
                this.computeStatus();
            }
            return this.filters.isEmpty() || !this.filterEnvs.isEmpty();
        }

        public void computeStatus() {
            if (!this.filters.isEmpty()) {
                this.filterEnvs = CompletionHandler.this.modelManager.evalFilters(this.filters, this.env);
            }
        }

        public ActionUnreadyReason getUnreadyReason() {
            ListOfConstraint listOfConstraint = CompletionHandler.this.modelManager.testFilters(this.filters, this.env);
            return new UnsatisfiedConditionsUnreadyReason(this, this.filters, listOfConstraint, this.env);
        }

        public void handle(AgendaItem agendaItem) {
            Debug.expect(agendaItem == this.item);
            ListOfConstraint listOfConstraint = this.filters;
            if (listOfConstraint.isEmpty()) {
                this.adjustStatus(agendaItem);
                return;
            }
            List list = CompletionHandler.this.modelManager.reevaluateFilters(listOfConstraint);
            Debug.expect(!list.isEmpty(), "Cannot match filter conditions " + listOfConstraint);
            Set set = Variable.varsAnywhereIn(listOfConstraint);
            Set set2 = Variable.unboundVarsIn(set);
            Debug.noteln("Cond vars", (Object)set);
            Debug.noteln("Unbound", (Object)set2);
            if (set2.isEmpty()) {
                this.adjustStatus(agendaItem);
                return;
            }
            this.unboundVariables = set2;
            BindingViewer bindingViewer = new BindingViewer(CompletionHandler.this.ip2, set2){

                public void handleBindings(Map map) {
                    if (map != null) {
                        DoneAction.this.bind(map);
                    }
                }
            };
        }

        protected void bind(Map map) {
            try {
                CompletionHandler.this.modelManager.bindVariables(map);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Debug.displayException(illegalArgumentException);
            }
            Set set = Variable.unboundVarsIn(this.unboundVariables);
            Debug.noteln("Still unbound", (Object)set);
            if (set.isEmpty()) {
                this.adjustStatus(this.item);
            } else {
                this.item.setHandledBy(null);
            }
        }

        protected void adjustStatus(AgendaItem agendaItem) {
            agendaItem.setStatus(Collect.isEmpty(agendaItem.getChildren()) ? Status.COMPLETE : Status.EXECUTING);
        }
    }

    public class NotApplicableAction
    extends DoneAction {
        public NotApplicableAction(AgendaItem agendaItem) {
            super(agendaItem, "N/A", "N/A");
        }
    }

    @Deprecated
    public class SimpleDoneAction
    extends HandlerAction.Manual {
        AgendaItem item;

        public SimpleDoneAction(AgendaItem agendaItem) {
            this(agendaItem, "Done");
        }

        public SimpleDoneAction(AgendaItem agendaItem, String string) {
            this.item = agendaItem;
            this.shortDescription = string;
        }

        public boolean isReady() {
            return Collect.isEmpty(CompletionHandler.this.ip2.getModelManager().getNodeConditions(this.item));
        }

        public ActionUnreadyReason getUnreadyReason() {
            return new SimpleUnreadyReason((HandlerAction)this, new String[]{"Cannot be used when there are conditions.", "Use \"Satisfy conditions\" instead."});
        }
    }

    public static class NoAction
    extends HandlerAction.NoAction {
        AgendaItem item;

        public NoAction(AgendaItem agendaItem) {
            this.shortDescription = this.makeDescription(agendaItem);
            this.item = agendaItem;
        }

        public void handle(AgendaItem agendaItem) {
            Debug.noteln("No action for", (Object)agendaItem);
            Debug.expect(agendaItem.getHandledBy() == this);
            agendaItem.setHandledBy(null);
        }

        public String getActionDescription() {
            this.shortDescription = this.makeDescription(this.item);
            return this.shortDescription;
        }

        String makeDescription(AgendaItem agendaItem) {
            Object object;
            String string;
            if (agendaItem instanceof ActivityItem && (string = ((ActivityItem)(object = (ActivityItem)agendaItem)).getExpansionRefinementName()) != null) {
                return "Refined by " + string;
            }
            object = agendaItem.getHowHandled();
            if (object != null) {
                return object;
            }
            if (agendaItem.getStatus() == Status.COMPLETE) {
                return "Done";
            }
            return "   ";
        }
    }
}

