/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.domain.Constraint;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;
import ix.ip2.Ip2ModelManager;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.context.ContextHashMap;
import ix.util.context.ContextMap;
import ix.util.lisp.Symbol;
import java.util.Iterator;
import java.util.List;

public class AdviceManager {
    public static final Symbol S_ADVICE = Symbol.intern("advice");
    public static final Symbol S_EXPANSION_REFINEMENT = Symbol.intern("expansion-refinement");
    protected ContextMap verbToRefinementNames = new ContextHashMap();

    public AdviceManager(Ip2ModelManager ip2ModelManager) {
    }

    public void reset() {
        this.verbToRefinementNames.clearCompletely();
    }

    public void addConstraint(PNode pNode, Constraint constraint) {
        if (constraint.getRelation() != S_EXPANSION_REFINEMENT) {
            Debug.noteln("Can't handle " + constraint + " at " + pNode);
            return;
        }
        Symbol symbol = (Symbol)constraint.getParameter(0);
        List list = (List)constraint.getParameter(1);
        List list2 = (List)this.verbToRefinementNames.get(symbol);
        if (list2 != null && !Collect.equalAsSets(list2, list)) {
            throw new IllegalArgumentException("Conflicting expansion refinement advice for " + symbol + " -- " + list2 + " vs " + list);
        }
        Debug.noteln("Advice:", (Object)constraint);
        this.verbToRefinementNames.put(symbol, list);
    }

    public boolean isUsableRefinement(Refinement refinement) {
        Object object = refinement.getPattern().get(0);
        List list = (List)this.verbToRefinementNames.get(object);
        if (list == null) {
            int n = refinement.getPattern().size() - 1;
            Symbol symbol = Symbol.intern(object + "/" + n);
            list = (List)this.verbToRefinementNames.get(symbol);
            if (list == null) {
                return true;
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().toString().equals(refinement.getName())) continue;
            return true;
        }
        return false;
    }
}

