/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.Report;
import ix.icore.Status;
import ix.icore.TaskItem;
import ix.icore.domain.Refinement;
import ix.ip2.ActivityItem;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.ip2.ExpandHandler;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2ModelManager;
import ix.ip2.ItemHandler;
import ix.ip2.PanelController;
import ix.ip2.SimpleCompletionHandler;
import ix.ip2.log.ActivityHandledEvent;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.Util;
import ix.util.context.TypedContextValue;
import ix.util.lisp.LList;
import java.util.List;

public class ActivityAgenda
extends Agenda {
    private TypedContextValue __openOtherReportsActivity = new TypedContextValue<Object>(OtherReportsActivity.class, null);

    public ActivityAgenda(PanelController panelController) {
        super(panelController);
    }

    public void reset() {
        super.reset();
        this.__openOtherReportsActivity = new TypedContextValue<Object>(OtherReportsActivity.class, null);
    }

    public void clear() {
        super.clear();
        this.setOpenOtherReportsActivity(null);
    }

    public AgendaItem makeItem(LList lList) {
        return new ActivityItem(new Activity(lList));
    }

    public AgendaItem makeItem(TaskItem taskItem) {
        Util.mustBe(Activity.class, taskItem);
        return new ActivityItem((Activity)taskItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(AgendaItem agendaItem) {
        Ip2ModelManager ip2ModelManager = this.controller.getModelManager();
        ip2ModelManager.beginUndoableTransaction("Add activity");
        try {
            agendaItem.setPattern(ip2ModelManager.putVariablesInPattern(agendaItem.getPattern()));
            ip2ModelManager.addNode(agendaItem);
            agendaItem.computeStatus();
            super.addItem(agendaItem);
        }
        finally {
            ip2ModelManager.endUndoableTransaction("Add activity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemsBefore(AgendaItem agendaItem, List list) {
        Ip2ModelManager ip2ModelManager = this.controller.getModelManager();
        ip2ModelManager.beginUndoableTransaction("Add activities before");
        try {
            for (AgendaItem agendaItem2 : list) {
                agendaItem2.setPattern(ip2ModelManager.putVariablesInPattern(agendaItem2.getPattern()));
                agendaItem2.computeStatus();
            }
            ip2ModelManager.addNodesBefore(agendaItem, list);
            super.addItemsBefore(agendaItem, list);
        }
        finally {
            ip2ModelManager.endUndoableTransaction("Add activities before");
        }
    }

    public void removeItem(AgendaItem agendaItem) {
        Ip2ModelManager ip2ModelManager = this.controller.getModelManager();
        ip2ModelManager.removeNode(agendaItem);
        super.removeItem(agendaItem);
    }

    void logItemHandled(AgendaItem agendaItem, HandlerAction handlerAction) {
        String string = handlerAction.getActionDescription();
        ActivityHandledEvent activityHandledEvent = new ActivityHandledEvent();
        activityHandledEvent.setAction(string);
        agendaItem.addHistoryEvent(activityHandledEvent);
        super.logItemHandled(agendaItem, handlerAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptReport(Report report) {
        for (AgendaItem agendaItem : this.items) {
            if (agendaItem instanceof OtherReportsActivity || !agendaItem.wantsReport(report)) continue;
            agendaItem.addReport(report);
            return true;
        }
        if (this.openOtherReportsActivity() == null) {
            Ip2ModelManager ip2ModelManager = this.controller.getModelManager();
            ip2ModelManager.beginUndoableTransaction("Add other-reports activity");
            try {
                this.setOpenOtherReportsActivity(new OtherReportsActivity("Note other reports"));
                this.addItem(this.openOtherReportsActivity());
            }
            finally {
                ip2ModelManager.endUndoableTransaction("Add other-reports activity");
            }
        }
        this.openOtherReportsActivity().addReport(report);
        return true;
    }

    protected OtherReportsActivity openOtherReportsActivity() {
        return (OtherReportsActivity)this.__openOtherReportsActivity.get();
    }

    protected void setOpenOtherReportsActivity(OtherReportsActivity otherReportsActivity) {
        Debug.noteln("Setting open other reports to", (Object)otherReportsActivity);
        this.__openOtherReportsActivity.set(otherReportsActivity);
    }

    public void expandItem(AgendaItem agendaItem, Refinement refinement) {
        Refinement refinement2 = refinement;
        if (refinement2.getName() == null) {
            refinement2.setName("temporary partial schema");
        }
        ExpandHandler expandHandler = (ExpandHandler)Collect.findIf(this.handlers, Fn.isInstanceOf(ExpandHandler.class));
        HandlerAction handlerAction = expandHandler.makeManualExpandAction(agendaItem, refinement2);
        agendaItem.addAction(handlerAction);
        this.handleItem(agendaItem, handlerAction);
        this.fireItemHandled(agendaItem, handlerAction);
    }

    public class OtherReportsActivity
    extends ActivityItem {
        public OtherReportsActivity(String string) {
            super(new Activity(string));
            this.setStatus(Status.EXECUTING);
        }

        public boolean wantsReport(Report report) {
            Debug.noteln("Other reports activity asked if it wants", (Object)report);
            return this.getStatus() != Status.COMPLETE;
        }

        public boolean wantsActionsFrom(ItemHandler itemHandler) {
            return itemHandler instanceof SimpleCompletionHandler;
        }

        public boolean actionCanBeTakenNow(HandlerAction handlerAction) {
            return this.getStatus() == Status.POSSIBLE || handlerAction instanceof HandlerAction.Manual && this.getStatus() == Status.EXECUTING;
        }

        public void setStatus(Status status) {
            if (status == Status.COMPLETE && this == ActivityAgenda.this.openOtherReportsActivity()) {
                ActivityAgenda.this.setOpenOtherReportsActivity(null);
            }
            super.setStatus(status);
        }

        public void computeStatus() {
        }

        public void addReport(Report report) {
            super.addReport(report);
            if (this.getPriority().compareTo(report.getPriority()) < 0) {
                this.setPriority(report.getPriority());
            }
        }

        protected void setStatusBasedOn(Report report) {
        }
    }
}

