/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.util.Debug;
import ix.util.Fn;
import ix.util.Strings;
import java.lang.reflect.Method;

public abstract class ToolController {
    protected String toolName;
    protected Object tool = null;

    protected ToolController() {
    }

    public ToolController(String string) {
        this.toolName = string;
    }

    public String getToolName() {
        return this.toolName;
    }

    protected abstract Object createTool();

    public Object getTool() {
        return this.tool;
    }

    public Object ensureTool() {
        if (this.tool == null) {
            this.setTool();
        }
        return this.tool;
    }

    public Object ensureToolVisible() {
        this.ensureTool();
        this.setToolVisible(true);
        return this.tool;
    }

    public void setTool() {
        this.tool = this.createTool();
        Debug.noteln("Assigned tool " + Strings.quote(this.toolName) + ": " + this.tool);
    }

    public void setToolVisible(boolean bl) {
        Object[] objectArray = new Object[]{bl};
        Method method = Fn.getMethod(this.tool, "setVisible", objectArray);
        if (method == null) {
            throw new UnsupportedOperationException("Can't make tool " + Strings.quote(this.toolName) + " visible.");
        }
        Fn.apply(this.tool, method, objectArray);
    }
}

