/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.iface.util.CatchingActionListener;
import ix.iface.util.GridColumn;
import ix.iface.util.ValueComboBox;
import ix.iface.util.VerticalPanel;
import ix.util.ConsistencyException;
import ix.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public abstract class SelectionPanel
extends JPanel {
    JFrame frame;
    String nameColTitle;
    String choiceColTitle;
    SelectionTable selectionTable;

    public SelectionPanel(JFrame jFrame, String string, String string2) {
        this.frame = jFrame;
        this.nameColTitle = string;
        this.choiceColTitle = string2;
        this.selectionTable = new SelectionTable();
        this.setupPanelContents();
    }

    void setupPanelContents() {
        this.setLayout(new BorderLayout());
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.addFixedHeight(this.selectionTable);
        this.add((Component)new JScrollPane(verticalPanel), "Center");
        this.add((Component)new ButtonPanel(), "South");
    }

    protected void load() {
        this.selectionTable.loadTable();
    }

    protected void reload() {
        this.selectionTable.reloadTable();
    }

    protected void addTableEntry(String string, Object object) {
        new Row(string, object).insertInTable(this.selectionTable);
    }

    protected abstract ValueComboBox makeValueComboBox();

    protected abstract Map getCurrentValueMap();

    protected abstract void entryDeleted(String var1);

    protected abstract void valueChanged(String var1, Object var2);

    protected abstract void entryAdded(String var1, Object var2);

    class Row {
        String name;
        Object value;
        JTextField nameText;
        ValueComboBox valChoice;

        Row(String string, Object object) {
            this.name = string;
            this.value = object;
            this.nameText = new JTextField(string);
            this.valChoice = SelectionPanel.this.makeValueComboBox();
            this.nameText.setEditable(false);
            this.valChoice.setSelectedValue(object);
        }

        Row(JTextField jTextField, ValueComboBox valueComboBox) {
            this.name = "";
            this.value = valueComboBox.getSelectedValue();
            this.nameText = jTextField;
            this.valChoice = valueComboBox;
        }

        Object getSelectedValue() {
            return this.valChoice.getSelectedValue();
        }

        void reset() {
            if (this.nameText.isEditable()) {
                this.nameText.setText(this.name);
            }
            this.valChoice.setSelectedValue(this.value);
        }

        void addToTable(SelectionTable selectionTable) {
            selectionTable.rows.add(this);
            selectionTable.nameCol.add(this.nameText);
            selectionTable.choiceCol.add(this.valChoice);
        }

        void insertInTable(SelectionTable selectionTable) {
            Debug.noteln("INserting", (Object)this.name);
            Debug.noteln("ROWS", (Object)selectionTable.rows);
            ListIterator listIterator = selectionTable.rows.listIterator();
            while (listIterator.hasNext()) {
                Row row = (Row)listIterator.next();
                Debug.noteln("Comparing", (Object)row.name);
                if (!row.nameText.isEditable() && row.name.compareTo(this.name) <= 0) continue;
                break;
            }
            int n = listIterator.nextIndex() - 1 + 1;
            selectionTable.rows.add(n - 1, this);
            selectionTable.nameCol.add((Component)this.nameText, n);
            selectionTable.choiceCol.add((Component)this.valChoice, n);
            selectionTable.invalidate();
            SelectionPanel.this.frame.validate();
            SelectionPanel.this.frame.pack();
        }

        public String toString() {
            return "row[" + this.name + " --> " + this.getSelectedValue() + "]";
        }
    }

    class SelectionTable
    extends JPanel {
        List rows = new LinkedList();
        GridColumn nameCol;
        GridColumn choiceCol;
        Row newEntryRow;
        boolean ignoreReloads;

        SelectionTable() {
            this.nameCol = new GridColumn(SelectionPanel.this.nameColTitle);
            this.choiceCol = new GridColumn(SelectionPanel.this.choiceColTitle);
            this.ignoreReloads = false;
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createEtchedBorder());
            this.add(this.nameCol);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.choiceCol);
        }

        void loadTable() {
            Map map = SelectionPanel.this.getCurrentValueMap();
            for (String string : map.keySet()) {
                Object v = map.get(string);
                Row row = new Row(string, v);
                row.addToTable(this);
            }
            this.newEntryRow = new Row(new JTextField(40), SelectionPanel.this.makeValueComboBox());
            this.newEntryRow.addToTable(this);
        }

        void reloadTable() {
            if (this.ignoreReloads) {
                Debug.noteln("Selection table ignoring a reload");
                return;
            }
            this.nameCol.reset();
            this.choiceCol.reset();
            this.rows.clear();
            this.loadTable();
            this.invalidate();
            SelectionPanel.this.frame.validate();
            SelectionPanel.this.frame.pack();
        }

        void undoUncommittedChanges() {
            for (Row row : this.rows) {
                row.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commitChanges() {
            try {
                Object object2;
                this.ignoreReloads = true;
                for (Object object2 : this.rows) {
                    if (object2 == this.newEntryRow) continue;
                    Object object3 = ((Row)object2).getSelectedValue();
                    if (object3 == null) {
                        SelectionPanel.this.entryDeleted(((Row)object2).name);
                        continue;
                    }
                    if (object3 == ((Row)object2).value) continue;
                    SelectionPanel.this.valueChanged(((Row)object2).name, object3);
                }
                String string = this.newEntryRow.nameText.getText().trim();
                if (!string.equals("") && (object2 = this.newEntryRow.getSelectedValue()) != null) {
                    SelectionPanel.this.entryAdded(string, object2);
                }
            }
            finally {
                this.ignoreReloads = false;
            }
            this.reloadTable();
        }
    }

    class ButtonPanel
    extends JPanel
    implements ActionListener {
        ButtonPanel() {
            this.add(this.makeButton("Commit"));
            this.add(this.makeButton("Undo Uncommitted Changes"));
        }

        protected JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(this));
            return jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Selectin panel action:", (Object)string);
            if (string.equals("Commit")) {
                SelectionPanel.this.selectionTable.commitChanges();
            } else if (string.equals("Undo Uncommitted Changes")) {
                SelectionPanel.this.selectionTable.undoUncommittedChanges();
            } else {
                throw new ConsistencyException("Nothing to do for " + string);
            }
        }
    }
}

