/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.util.Debug;
import ix.util.Strings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioButtonBox
extends JPanel {
    protected List actionListeners = new LinkedList();
    protected ButtonGroup group = new ButtonGroup();
    protected String selection = null;
    protected ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            RadioButtonBox.this.selection = actionEvent.getActionCommand();
            Debug.noteln("Radio button selection", (Object)RadioButtonBox.this.selection);
            for (ActionListener actionListener : RadioButtonBox.this.actionListeners) {
                actionListener.actionPerformed(actionEvent);
            }
        }
    };

    public RadioButtonBox(int n) {
        this.setLayout(new BoxLayout(this, n));
    }

    public static RadioButtonBox createHorizontalBox() {
        return new RadioButtonBox(0);
    }

    public static RadioButtonBox createVerticalBox() {
        return new RadioButtonBox(1);
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String string) {
        Enumeration<AbstractButton> enumeration = this.group.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (!jRadioButton.getText().equals(string)) continue;
            jRadioButton.doClick();
            return;
        }
        throw new RuntimeException("No button with text " + Strings.quote(string));
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)component;
            this.group.add(jRadioButton);
            jRadioButton.addActionListener(this.listener);
            if (jRadioButton.isSelected()) {
                this.selection = jRadioButton.getActionCommand();
            }
        }
        super.addImpl(component, object, n);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }
}

