/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.AbstractEditorPanel;
import ix.iface.ui.table.AbstractIXTableModel;
import ix.iface.ui.table.IXTable;
import ix.iface.ui.tree.EditableTreeModel;
import ix.iface.ui.tree.IXTreeNode;
import ix.iface.ui.tree.IXTrees;
import ix.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ListEditorPanel
extends AbstractEditorPanel
implements ActionListener,
ListSelectionListener {
    private HashSet listeners = new HashSet();

    public ListEditorPanel() {
        super(false);
    }

    public ListEditorPanel(boolean bl) {
        super(false, bl);
    }

    public ListEditorPanel(EventListener eventListener, String string, JComponent jComponent) {
        this(eventListener, string, false, jComponent);
    }

    public ListEditorPanel(EventListener eventListener, String string, String[] stringArray) {
        this(eventListener, string, false, stringArray);
    }

    public ListEditorPanel(EventListener eventListener, String string, JComponent jComponent, String[] stringArray) {
        this(eventListener, string, false, jComponent, stringArray);
    }

    public ListEditorPanel(EventListener eventListener, String string, boolean bl, JComponent jComponent) {
        super(eventListener, string, bl, jComponent);
        this.listen(eventListener);
    }

    public ListEditorPanel(EventListener eventListener, String string, boolean bl, String[] stringArray) {
        super(eventListener, string, bl, stringArray);
        this.listen(eventListener);
    }

    public ListEditorPanel(EventListener eventListener, String string, boolean bl, JComponent jComponent, String[] stringArray) {
        super(eventListener, string, bl, jComponent, stringArray);
        this.listen(eventListener);
    }

    public boolean isListItem() {
        return true;
    }

    public Object getData() {
        Class<?> clazz = this.itemComponent.getClass();
        if (this.itemComponent instanceof JList) {
            return this.getListData();
        }
        if (this.itemComponent instanceof JComboBox) {
            return this.getComboData();
        }
        if (this.itemComponent instanceof JTable) {
            return this.getTableData();
        }
        if (this.itemComponent instanceof JTree) {
            return this.getTreeData();
        }
        Debug.noteln("Cannot get data from object of type", this.itemComponent.getClass());
        return null;
    }

    private void listen(EventListener eventListener) {
        if (eventListener instanceof ListSelectionListener) {
            this.addListSelectionListener((ListSelectionListener)eventListener);
        }
        if (this.itemComponent instanceof JComboBox) {
            ((JComboBox)this.itemComponent).addActionListener(this);
        } else if (this.itemComponent instanceof JList) {
            ((JList)this.itemComponent).addListSelectionListener(this);
        } else if (this.itemComponent instanceof JTable) {
            ((JTable)this.itemComponent).getSelectionModel().addListSelectionListener(this);
        }
    }

    private Object[] getListData() {
        ListModel listModel = ((JList)this.itemComponent).getModel();
        return this.getModelData(listModel);
    }

    private Object[] getComboData() {
        ComboBoxModel comboBoxModel = ((JComboBox)this.itemComponent).getModel();
        return this.getModelData(comboBoxModel);
    }

    private Object[] getTableData() {
        TableModel tableModel = ((JTable)this.itemComponent).getModel();
        Object[] objectArray = new Object[]{};
        if (tableModel instanceof AbstractIXTableModel) {
            List list = ((AbstractIXTableModel)tableModel).getData();
            if (list != null) {
                return list.toArray();
            }
            return objectArray;
        }
        Debug.noteln("LEP: Getting data from a table is not yet implemented");
        return objectArray;
    }

    private Object[] getTreeData() {
        TreeModel treeModel = ((JTree)this.itemComponent).getModel();
        Object[] objectArray = new Object[]{};
        if (treeModel instanceof EditableTreeModel) {
            List list = ((EditableTreeModel)treeModel).findUserObjects();
            if (list != null) {
                objectArray = list.toArray();
            }
        } else {
            Debug.noteln("LEP: Getting data from a tree is not yet implemented");
        }
        return objectArray;
    }

    private Object[] getModelData(ListModel listModel) {
        int n = listModel.getSize();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = listModel.getElementAt(i);
        }
        return objectArray;
    }

    public void setListData(Object[] objectArray) {
        TreeModel treeModel;
        boolean bl = this.itemComponent.isEnabled();
        this.itemComponent.setEnabled(false);
        if (JList.class.isInstance(this.itemComponent)) {
            ((JList)this.itemComponent).removeAll();
            ((JList)this.itemComponent).setListData(objectArray);
        } else if (JComboBox.class.isInstance(this.itemComponent)) {
            JComboBox jComboBox = (JComboBox)this.itemComponent;
            jComboBox.removeAllItems();
            for (int i = 0; i < objectArray.length; ++i) {
                jComboBox.addItem(objectArray[i]);
            }
        } else if (JTable.class.isInstance(this.itemComponent)) {
            TableModel tableModel = ((JTable)this.itemComponent).getModel();
            if (AbstractIXTableModel.class.isInstance(tableModel)) {
                ((AbstractIXTableModel)tableModel).setData(objectArray);
                ((AbstractIXTableModel)tableModel).fireTableDataChanged();
            }
        } else if (this.itemComponent instanceof JTree && (treeModel = ((JTree)this.itemComponent).getModel()) instanceof EditableTreeModel) {
            try {
                EditableTreeModel editableTreeModel = (EditableTreeModel)treeModel.getClass().newInstance();
                IXTrees.setupTreeModel(editableTreeModel, Arrays.asList(objectArray));
                ((JTree)this.itemComponent).setModel(editableTreeModel);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
            }
        }
        this.itemComponent.setEnabled(bl);
        this.dataSet(objectArray);
    }

    public void setData(Object object) {
        if (object == null) {
            this.removeData();
        } else if (object instanceof Collection) {
            this.setListData(((Collection)object).toArray());
        } else {
            try {
                this.setListData((Object[])object);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
            }
        }
    }

    public void removeData() {
        Object[] objectArray = new String[]{};
        this.setListData(objectArray);
    }

    public void setSelectedIndex(int n) {
        try {
            if (this.itemComponent instanceof JList) {
                ((JList)this.itemComponent).setSelectedIndex(n);
            } else if (this.itemComponent instanceof JComboBox) {
                ((JComboBox)this.itemComponent).setSelectedIndex(n);
            } else if (this.itemComponent instanceof JTable) {
                ((JTable)this.itemComponent).setRowSelectionInterval(n, n);
            } else if (this.itemComponent instanceof JTree) {
                ((JTree)this.itemComponent).setSelectionRow(n);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public int getSelectedIndex() {
        if (this.itemComponent instanceof JList) {
            return ((JList)this.itemComponent).getSelectedIndex();
        }
        if (this.itemComponent instanceof JComboBox) {
            return ((JComboBox)this.itemComponent).getSelectedIndex();
        }
        if (this.itemComponent instanceof JTable) {
            return ((JTable)this.itemComponent).getSelectedRow();
        }
        if (this.itemComponent instanceof JTree) {
            int[] nArray = ((JTree)this.itemComponent).getSelectionRows();
            if (nArray.length == 0) {
                return -1;
            }
            return nArray[0];
        }
        return -1;
    }

    public void setSelectedObject(Object object) {
        if (this.itemComponent instanceof JList) {
            ((JList)this.itemComponent).setSelectedValue(object, true);
        } else if (this.itemComponent instanceof JComboBox) {
            ((JComboBox)this.itemComponent).setSelectedItem(object);
        } else if (this.itemComponent instanceof IXTable) {
            ((IXTable)this.itemComponent).setSelectedObject(object);
        } else if (this.itemComponent instanceof JTable) {
            TableModel tableModel = ((JTable)this.itemComponent).getModel();
            if (tableModel instanceof AbstractIXTableModel) {
                int n = ((AbstractIXTableModel)tableModel).getObjectRow(object);
                ((JTable)this.itemComponent).setRowSelectionInterval(n, n);
            } else {
                Debug.noteln("WARNING: cannot set table object selection for", tableModel.getClass());
            }
        } else if (this.itemComponent instanceof JTree) {
            Debug.noteln("WARNING: cannot set object selection for trees");
        }
    }

    public Object getSelectedObject() {
        if (this.itemComponent instanceof JList) {
            return ((JList)this.itemComponent).getSelectedValue();
        }
        if (this.itemComponent instanceof JComboBox) {
            return ((JComboBox)this.itemComponent).getSelectedItem();
        }
        if (this.itemComponent instanceof IXTable) {
            return ((IXTable)this.itemComponent).getSelectedObject();
        }
        if (this.itemComponent instanceof JTable) {
            int n = ((JTable)this.itemComponent).getSelectedRow();
            if (n < 0) {
                return null;
            }
            TableModel tableModel = ((JTable)this.itemComponent).getModel();
            if (tableModel instanceof AbstractIXTableModel) {
                return ((AbstractIXTableModel)tableModel).getRowObject(n);
            }
            return ((JTable)this.itemComponent).getValueAt(n, 0);
        }
        if (this.itemComponent instanceof JTree) {
            TreePath treePath = ((JTree)this.itemComponent).getSelectionPath();
            if (treePath == null) {
                return null;
            }
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (treeNode == null) {
                return null;
            }
            if (treeNode instanceof DefaultMutableTreeNode) {
                return ((DefaultMutableTreeNode)treeNode).getUserObject();
            }
            if (treeNode instanceof IXTreeNode) {
                return ((IXTreeNode)treeNode).getUserObject();
            }
            return treeNode;
        }
        Debug.noteln("WARNING: cannot get selection from a", this.itemComponent.getClass());
        return null;
    }

    public boolean setRenderer(ListCellRenderer listCellRenderer) {
        if (this.itemComponent instanceof JList) {
            ((JList)this.itemComponent).setCellRenderer(listCellRenderer);
            return true;
        }
        if (this.itemComponent instanceof JComboBox) {
            ((JComboBox)this.itemComponent).setRenderer(listCellRenderer);
            return true;
        }
        return false;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener != null) {
            this.listeners.add(listSelectionListener);
        }
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener != null) {
            this.listeners.remove(listSelectionListener);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ListSelectionListener listSelectionListener : this.listeners) {
                listSelectionListener.valueChanged(listSelectionEvent);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != null && actionEvent.getSource().equals(this.itemComponent) && this.itemComponent instanceof JComboBox) {
            int n = this.getSelectedIndex();
            this.valueChanged(new ListSelectionEvent(actionEvent.getSource(), n, n, false));
        }
    }
}

