/*
 * Decompiled with CFR 0.152.
 */
package ix.applet;

import ix.applet.AppletCommunicationTool;
import ix.applet.AppletMessage;
import ix.applet.MessageMemory;
import ix.icore.IXAgent;
import ix.iface.util.Reporting;
import ix.ip2.Ip2;
import ix.ip2.Ip2Applet;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.Util;
import ix.util.xml.XML;
import java.applet.Applet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.SwingUtilities;

public class AppletCommunicationStrategy
implements IPC.CommunicationStrategy {
    AppletCommunicationTool tool;
    Ip2 agent;
    URL docBase;
    IPC.MessageListener messageListener;
    boolean ableToSend = false;
    volatile int expectedSeqNo = 0;
    MessageMemory messageMap = new MessageMemory();

    void setTool(AppletCommunicationTool appletCommunicationTool) {
        this.tool = appletCommunicationTool;
    }

    String getAgentName() {
        return this.agent.getAgentSymbolName();
    }

    synchronized boolean isAbleToSend() {
        return this.ableToSend;
    }

    synchronized void setIsAbleToSend(boolean bl) {
        this.ableToSend = bl;
    }

    synchronized URL getDocumentBase() {
        return this.docBase;
    }

    public synchronized void appletStart() {
        Debug.noteln(this + "appletStart() called");
    }

    public synchronized void appletStop() {
        Debug.noteln(this + "appletStop() called");
    }

    public synchronized void appletDestroy() {
        Debug.noteln(this + "appletDestroy() called");
    }

    public synchronized void setupServer(Object object, IPC.MessageListener messageListener) {
        Debug.noteln("Setting up AppletCommunicationStrategy server.");
        this.messageListener = messageListener;
        this.agent = (Ip2)IXAgent.getAgent();
        if (this.agent instanceof Ip2Applet.AppletIp2) {
            Applet applet = ((Ip2Applet.AppletIp2)this.agent).getApplet();
            this.docBase = applet.getDocumentBase();
        } else if (Parameters.haveParameter("base-url")) {
            try {
                this.docBase = new URL(Parameters.getParameter("base-url"));
            }
            catch (MalformedURLException malformedURLException) {
                Debug.displayException("Invalid base-url for applet communication strategy", malformedURLException);
                return;
            }
        } else {
            Util.displayAndWait(null, "No base-url was given for the applet communication strategy");
            return;
        }
        this.agent.addTool(new AppletCommunicationTool.Controller(this));
    }

    void registerAs(String string) {
        Debug.expect(SwingUtilities.isEventDispatchThread(), "not in Swing");
        Debug.expect(!this.isAbleToSend(), "Registering when already registered");
        Debug.noteln("Trying to register as", (Object)string);
        AppletMessage appletMessage = new AppletMessage(this.getAgentName(), "register-as", string);
        appletMessage.setSeqNo(this.expectedSeqNo - 1);
        Object object = this.requestObject(appletMessage);
        if (!object.equals("ok")) {
            throw new IPC.IPCException(object.toString());
        }
        this.transcript("Registered as " + string);
        this.agent.setAgentSymbolName(string);
        this.setIsAbleToSend(true);
        new ReceiveThread().start();
    }

    void serverUnavailable() {
        Util.swingAndWait(new Runnable(){

            public void run() {
                AppletCommunicationStrategy.this.tool.needToReregister();
            }
        });
    }

    protected void transcript(final String string) {
        Debug.noteln("Transcript:", (Object)string);
        Util.swingAndWait(new Runnable(){

            public void run() {
                AppletCommunicationStrategy.this.do_transcript(Reporting.dateString() + " " + string);
            }
        });
    }

    protected void do_transcript(String string) {
        this.tool.transcript(string);
    }

    public synchronized void sendObject(Object object, Object object2) {
        if (!this.isAbleToSend()) {
            throw new UnsupportedOperationException("Cannot send to " + object + " until you have registered with the message server.");
        }
        this.transcript("Sending to " + object + ": " + Reporting.description(object2));
        AppletMessage appletMessage = new AppletMessage(this.getAgentName(), "send-to", object, object2);
        appletMessage.setSendDate(new Date());
        try {
            Object object3 = this.requestObject(appletMessage);
            Debug.noteln("Received", object3);
            if (!object3.equals("ok")) {
                throw new IPC.IPCException("Unexpected reply from message-server: " + object3);
            }
        }
        catch (RuntimeException runtimeException) {
            Debug.noteln("sendObject rethrowing", (Object)Debug.describeException(runtimeException));
            throw runtimeException;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new RethrownException(exception);
        }
    }

    protected Object requestObject(AppletMessage appletMessage) {
        String string = "no reply";
        try {
            string = this.sendText(this.encodeForSend(appletMessage));
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            throw new IPC.IPCException(iOException);
        }
        if (string.startsWith("<")) {
            String string2;
            Object object = this.decodeReply(string);
            if (object instanceof String && (string2 = (String)object).startsWith("Server exception: ")) {
                throw this.interpretServerException(string2);
            }
            return object;
        }
        if (string.startsWith("Exception: ")) {
            throw this.interpretRelayException(string);
        }
        throw new IPC.IPCException("Request failed because " + string);
    }

    RuntimeException interpretServerException(String string) {
        return new IPC.IPCException(string);
    }

    RuntimeException interpretRelayException(String string) {
        Debug.expect(string.startsWith("Exception: "));
        String string2 = Strings.afterFirst(": ", string);
        if (string2.startsWith("BrokenConnectionException: ")) {
            String string3 = Strings.afterFirst(": ", string2);
            return new IPC.BrokenConnectionException(string3);
        }
        if (string2.startsWith("IPCException: Cannot connect to message-server")) {
            String string4 = Strings.afterFirst("caused by ", string2);
            return new ConnectFailure(string4);
        }
        return new IPC.IPCException("Request failed because " + string);
    }

    protected String encodeForSend(AppletMessage appletMessage) {
        return XML.objectToXMLString(appletMessage);
    }

    protected Object decodeReply(String string) {
        return XML.objectFromXML(string);
    }

    protected String sendText(String string) throws MalformedURLException, IOException {
        String string2;
        Debug.noteln("Applet sending text", (Object)string);
        URL uRL = new URL(this.docBase, "message.cgi");
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Content-Type", "text/plain; charset=utf-8");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream(), "utf-8");
        outputStreamWriter.write(string);
        outputStreamWriter.write("\r\n");
        ((Writer)outputStreamWriter).close();
        BufferedReader bufferedReader = new BufferedReader(this.makeReader(uRLConnection));
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            linkedList.add(string2);
        }
        bufferedReader.close();
        String string3 = Strings.joinLines(linkedList).trim();
        Debug.noteln("Applet received text", (Object)string3);
        return string3;
    }

    protected InputStreamReader makeReader(URLConnection uRLConnection) throws IOException, UnsupportedEncodingException {
        InputStream inputStream = uRLConnection.getInputStream();
        String string = uRLConnection.getContentEncoding();
        if (string == null) {
            return new InputStreamReader(inputStream);
        }
        return new InputStreamReader(inputStream, string);
    }

    static class ConnectFailure
    extends IPC.IPCException {
        ConnectFailure(String string) {
            super(string);
        }
    }

    class ReceiveThread
    extends Thread {
        String ourName;

        ReceiveThread() {
            this.ourName = AppletCommunicationStrategy.this.getAgentName();
        }

        public void run() {
            AppletMessage appletMessage = null;
            while (true) {
                try {
                    appletMessage = this.nextMessage(appletMessage);
                }
                catch (IPC.BrokenConnectionException brokenConnectionException) {
                    AppletCommunicationStrategy.this.transcript("Connection problem: " + Debug.describeException(brokenConnectionException));
                    Debug.displayException("Exception while waiting for input.  Probably means the message server has exited.  Another exception may follow.  This exception was", brokenConnectionException);
                    continue;
                }
                catch (ConnectFailure connectFailure) {
                    AppletCommunicationStrategy.this.setIsAbleToSend(false);
                    AppletCommunicationStrategy.this.transcript("Connection problem: " + Debug.describeException(connectFailure));
                    Debug.displayException(connectFailure);
                    AppletCommunicationStrategy.this.serverUnavailable();
                    return;
                }
                catch (Throwable throwable) {
                    AppletCommunicationStrategy.this.transcript("Receive failure: " + Debug.describeException(throwable));
                    Debug.displayException("Exception while waiting for input.  Probably a timeout that can be ignored.  The exception was", throwable);
                    continue;
                }
                try {
                    this.handleMessage(appletMessage);
                    continue;
                }
                catch (Throwable throwable) {
                    AppletCommunicationStrategy.this.transcript(Debug.describeException(throwable));
                    Debug.displayException(throwable);
                    continue;
                }
                break;
            }
        }

        AppletMessage nextMessage(AppletMessage appletMessage) {
            Object object;
            AppletCommunicationStrategy.this.transcript("Waiting for next message ...");
            AppletMessage appletMessage2 = new AppletMessage(AppletCommunicationStrategy.this.getAgentName(), "get-message");
            if (appletMessage != null) {
                appletMessage2.setSeqNo(appletMessage.getSeqNo());
            }
            if (!((object = AppletCommunicationStrategy.this.requestObject(appletMessage2)) instanceof AppletMessage)) {
                throw new ClassCastException("Received an instance of " + object.getClass().getName() + " instead of an AppletMessage.");
            }
            AppletMessage appletMessage3 = (AppletMessage)object;
            Debug.expect(appletMessage3.getCommand().equals("send-to"));
            Debug.expect(appletMessage3.getArg(0).equals(this.ourName));
            return appletMessage3;
        }

        void handleMessage(AppletMessage appletMessage) {
            Integer n = appletMessage.getSequenceNumber();
            int n2 = appletMessage.getSeqNo();
            Debug.expect(n2 == n);
            if (n2 == AppletCommunicationStrategy.this.expectedSeqNo) {
                Debug.expect(!AppletCommunicationStrategy.this.messageMap.containsKey(n));
                ++AppletCommunicationStrategy.this.expectedSeqNo;
            } else if (n2 > AppletCommunicationStrategy.this.expectedSeqNo) {
                Debug.noteln("Missing messages between " + AppletCommunicationStrategy.this.expectedSeqNo + " and " + n2);
                AppletCommunicationStrategy.this.expectedSeqNo = n2 + 1;
            } else {
                Debug.expect(n2 < AppletCommunicationStrategy.this.expectedSeqNo);
                if (AppletCommunicationStrategy.this.messageMap.containsKey(n)) {
                    AppletCommunicationStrategy.this.transcript("Received " + n2 + " again");
                    return;
                }
                Debug.noteln("Received gap message", n2);
            }
            Object object = appletMessage.getArg(1);
            AppletCommunicationStrategy.this.transcript("Received " + n2 + ": " + Reporting.description(object));
            AppletCommunicationStrategy.this.messageMap.remember(appletMessage);
            AppletCommunicationStrategy.this.messageListener.messageReceived(new IPC.BasicInputMessage(object));
        }
    }
}

