/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode.lowlevel;

import com.techtrader.modules.tools.bytecode.lowlevel.ConstantEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.LowLevelConstants;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DoubleEntry
implements ConstantEntry,
LowLevelConstants {
    private double _value = 0.0;

    public int getType() {
        return 6;
    }

    public double getValue() {
        return this._value;
    }

    public void setValue(double d) {
        this._value = d;
    }

    public Object getConstantValue() {
        return new Double(this._value);
    }

    public void setConstantValue(Object object) {
        this._value = ((Number)object).doubleValue();
    }

    public void readData(DataInput dataInput) throws IOException {
        this.setValue(dataInput.readDouble());
    }

    public void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.getValue());
    }

    public String getKey() {
        return this.getType() + "|" + this.getValue();
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterDoubleEntry(this);
        bCVisitor.exitDoubleEntry(this);
    }
}

