/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.regression.DiHyperCube;
import com.hp.hpl.jena.regression.HyperCube;
import java.util.Random;

public class testMatch {
    static int QUANTITY = 1;
    static int DIMENSION = 6;
    static boolean QUIET = true;
    private String test;
    private Random random;
    private int n = 0;
    private Model m1;
    private Model m2;
    private boolean inError = false;

    protected static void doTest(Model model, Model model2) {
        new testMatch(4011, model, model2).test();
        System.out.println("End testMatch");
    }

    testMatch(int n, Model model, Model model2) {
        this.test = "testMatch seed=" + n;
        if (!QUIET) {
            System.out.println("Beginning " + this.test);
        }
        this.random = new Random(n);
        this.m1 = model;
        this.m2 = model2;
    }

    private static void empty(Model model) {
        StmtIterator stmtIterator = model.listStatements();
        while (stmtIterator.hasNext()) {
            stmtIterator.nextStatement();
            stmtIterator.remove();
        }
    }

    void test() {
        this.test2HyperCube(DIMENSION, QUANTITY);
        this.test4DiHyperCube(DIMENSION, QUANTITY, true);
        this.test4DiHyperCube(DIMENSION, QUANTITY, false);
        this.test4ToggleHyperCube(DIMENSION, QUANTITY, true);
        this.test4ToggleHyperCube(DIMENSION, QUANTITY, false);
        if (QUANTITY > 5) {
            this.test2DiHyperCube(DIMENSION, QUANTITY, true);
            this.test2DiHyperCube(DIMENSION, QUANTITY, false);
            this.test4HyperCube(DIMENSION, QUANTITY, true);
            this.test4HyperCube(DIMENSION, QUANTITY, false);
        }
    }

    private void test2DiHyperCube(int n, int n2, boolean bl) {
        try {
            int n4;
            int n5 = 1 << n;
            int n6 = n2 / 10;
            if (n6 == 0) {
                n6 = 1;
            }
            if (!QUIET) {
                System.out.print("2di " + n + "x" + n2 + ":");
                System.out.flush();
            }
            long l = System.currentTimeMillis();
            long l2 = 0L;
            for (int i = 0; i < n2; ++i) {
                int n7;
                ++this.n;
                testMatch.empty(this.m1);
                ++this.n;
                testMatch.empty(this.m2);
                while (bl != DiHyperCube.equal(n7 = this.random.nextInt(n5), n4 = this.random.nextInt(n5))) {
                }
                ++this.n;
                new DiHyperCube(n, this.m1).dupe(n7).dupe(n7).dupe(n7);
                ++this.n;
                new DiHyperCube(n, this.m2).dupe(n4).dupe(n4).dupe(n4);
                if (!QUIET && (i + 1) % n6 == 0) {
                    System.out.print(bl ? "+" : "-");
                    System.out.flush();
                }
                ++this.n;
                long l3 = System.currentTimeMillis();
                if (this.m1.isIsomorphicWith(this.m2) != bl) {
                    this.error();
                }
                l2 += System.currentTimeMillis() - l3;
            }
            long l4 = System.currentTimeMillis() - l;
            n4 = (int)(l2 * 100L / l4);
            int n8 = (int)(l2 / (long)n2);
            if (!QUIET) {
                System.out.println("time: " + n8 + "ms (" + n4 + "%)");
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    private void test4DiHyperCube(int n, int n2, boolean bl) {
        try {
            int n4;
            int n5;
            int n6 = 1 << n;
            int n7 = n2 / 10;
            if (n7 == 0) {
                n7 = 1;
            }
            if (!QUIET) {
                System.out.print("4di " + n + "x" + n2 + ":");
            }
            System.out.flush();
            long l = System.currentTimeMillis();
            long l2 = 0L;
            for (int i = 0; i < n2; ++i) {
                int n8;
                int n9;
                ++this.n;
                testMatch.empty(this.m1);
                ++this.n;
                testMatch.empty(this.m2);
                do {
                    n9 = this.random.nextInt(n6);
                    n4 = this.random.nextInt(n6);
                } while (bl != DiHyperCube.equal(n9, n5 = this.random.nextInt(n6), n4, n8 = this.random.nextInt(n6)));
                ++this.n;
                new DiHyperCube(n, this.m1).dupe(n9).dupe(n9).dupe(n9).dupe(n5).dupe(n5).dupe(n5);
                ++this.n;
                new DiHyperCube(n, this.m2).dupe(n4).dupe(n4).dupe(n4).dupe(n8).dupe(n8).dupe(n8);
                if (!QUIET && (i + 1) % n7 == 0) {
                    System.out.print(bl ? "+" : "-");
                    System.out.flush();
                }
                ++this.n;
                long l3 = System.currentTimeMillis();
                if (this.m1.isIsomorphicWith(this.m2) != bl) {
                    System.out.println("(" + n9 + "," + n5 + "),(" + n4 + "," + n8 + ")");
                    this.error();
                }
                l2 += System.currentTimeMillis() - l3;
            }
            long l4 = System.currentTimeMillis() - l;
            n4 = (int)(l2 * 100L / l4);
            n5 = (int)(l2 / (long)n2);
            if (!QUIET) {
                System.out.println("time: " + n5 + "ms (" + n4 + "%)");
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    private void test2HyperCube(int n, int n2) {
        try {
            int n4;
            int n5 = 1 << n;
            int n6 = n2 / 10;
            if (n6 == 0) {
                n6 = 1;
            }
            if (!QUIET) {
                System.out.print("2:  " + n + "x" + n2 + ":");
            }
            System.out.flush();
            long l = System.currentTimeMillis();
            long l2 = 0L;
            for (int i = 0; i < n2; ++i) {
                ++this.n;
                testMatch.empty(this.m1);
                ++this.n;
                testMatch.empty(this.m2);
                int n7 = this.random.nextInt(n5);
                n4 = this.random.nextInt(n5);
                ++this.n;
                new HyperCube(n, this.m1).dupe(n7).dupe(n7).dupe(n7);
                ++this.n;
                new HyperCube(n, this.m2).dupe(n4).dupe(n4).dupe(n4);
                if (!QUIET && (i + 1) % n6 == 0) {
                    System.out.print("+");
                    System.out.flush();
                }
                ++this.n;
                long l3 = System.currentTimeMillis();
                if (!this.m1.isIsomorphicWith(this.m2)) {
                    this.error();
                }
                l2 += System.currentTimeMillis() - l3;
            }
            long l4 = System.currentTimeMillis() - l;
            n4 = (int)(l2 * 100L / l4);
            int n8 = (int)(l2 / (long)n2);
            if (!QUIET) {
                System.out.println("time: " + n8 + "ms (" + n4 + "%)");
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    private void test4HyperCube(int n, int n2, boolean bl) {
        try {
            int n4;
            int n5;
            int n6 = 1 << n;
            int n7 = n2 / 10;
            if (n7 == 0) {
                n7 = 1;
            }
            if (!QUIET) {
                System.out.print("4:  " + n + "x" + n2 + ":");
            }
            System.out.flush();
            long l = System.currentTimeMillis();
            long l2 = 0L;
            for (int i = 0; i < n2; ++i) {
                int n8;
                int n9;
                ++this.n;
                testMatch.empty(this.m1);
                ++this.n;
                testMatch.empty(this.m2);
                do {
                    n9 = this.random.nextInt(n6);
                    n4 = this.random.nextInt(n6);
                } while (bl != HyperCube.equal(n9, n5 = this.random.nextInt(n6), n4, n8 = this.random.nextInt(n6)));
                ++this.n;
                new HyperCube(n, this.m1).dupe(n9).dupe(n9).dupe(n9).dupe(n5).dupe(n5).dupe(n5);
                ++this.n;
                new HyperCube(n, this.m2).dupe(n4).dupe(n4).dupe(n4).dupe(n8).dupe(n8).dupe(n8);
                if (!QUIET && (i + 1) % n7 == 0) {
                    System.out.print(bl ? "+" : "-");
                    System.out.flush();
                }
                ++this.n;
                long l3 = System.currentTimeMillis();
                if (this.m1.isIsomorphicWith(this.m2) != bl) {
                    System.out.println("(" + n9 + "," + n5 + "),(" + n4 + "," + n8 + ")");
                    this.error();
                }
                l2 += System.currentTimeMillis() - l3;
            }
            long l4 = System.currentTimeMillis() - l;
            n4 = (int)(l2 * 100L / l4);
            n5 = (int)(l2 / (long)n2);
            if (!QUIET) {
                System.out.println("time: " + n5 + "ms (" + n4 + "%)");
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    private void test4ToggleHyperCube(int n, int n2, boolean bl) {
        try {
            int n4;
            int n5;
            int n6 = 1 << n;
            int n7 = n2 / 10;
            if (n7 == 0) {
                n7 = 1;
            }
            if (!QUIET) {
                System.out.print("4T: " + n + "x" + n2 + ":");
            }
            System.out.flush();
            long l = System.currentTimeMillis();
            long l2 = 0L;
            for (int i = 0; i < n2; ++i) {
                int n8;
                int n9;
                ++this.n;
                testMatch.empty(this.m1);
                ++this.n;
                testMatch.empty(this.m2);
                do {
                    n9 = this.random.nextInt(n6);
                    n4 = this.random.nextInt(n6);
                } while (bl != HyperCube.equal(n9, n5 = this.random.nextInt(n6), n4, n8 = this.random.nextInt(n6)));
                ++this.n;
                new HyperCube(n, this.m1).toggle(n9, n5);
                ++this.n;
                new HyperCube(n, this.m2).toggle(n4, n8);
                if (!QUIET && (i + 1) % n7 == 0) {
                    System.out.print(bl ? "+" : "-");
                    System.out.flush();
                }
                ++this.n;
                long l3 = System.currentTimeMillis();
                if (this.m1.isIsomorphicWith(this.m2) != bl) {
                    System.out.println("(" + n9 + "," + n5 + "),(" + n4 + "," + n8 + ")");
                    this.error();
                }
                l2 += System.currentTimeMillis() - l3;
            }
            long l4 = System.currentTimeMillis() - l;
            n4 = (int)(l2 * 100L / l4);
            n5 = (int)(l2 / (long)n2);
            if (!QUIET) {
                System.out.println("time: " + n5 + "ms (" + n4 + "%)");
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    private void error() {
        System.out.println(this.test + ": failed test " + Integer.toString(this.n));
        this.inError = true;
    }

    public void error(Exception exception) {
        System.out.println("Test Failed: " + this.test + " " + this.n + " " + exception.toString());
        this.inError = true;
    }

    public boolean getErrors() {
        return this.inError;
    }

    public static void main(String[] stringArray) {
        DIMENSION = 8;
        QUANTITY = 10;
        QUIET = false;
        testMatch.doTest(new ModelMem(), new ModelMem());
    }
}

