/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.impl.InfModelSpec;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.rdf.model.impl.PlainModelSpec;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.rdf.model.test.TestModelSpec;
import com.hp.hpl.jena.shared.BadDescriptionException;
import com.hp.hpl.jena.vocabulary.JMS;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestModelFactory
extends ModelTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestModelFactory;

    public TestModelFactory(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$rdf$model$test$TestModelFactory == null ? (class$com$hp$hpl$jena$rdf$model$test$TestModelFactory = TestModelFactory.class$("com.hp.hpl.jena.rdf.model.test.TestModelFactory")) : class$com$hp$hpl$jena$rdf$model$test$TestModelFactory);
    }

    public void testCreateDefaultModel() {
        ModelFactory.createDefaultModel().close();
    }

    public void testCreateSpecFails() {
        try {
            ModelFactory.createSpec(ModelFactory.createDefaultModel());
            TestModelFactory.fail((String)"empty descriptions should throw the appropriate exception");
        }
        catch (BadDescriptionException badDescriptionException) {
            TestModelFactory.pass();
        }
    }

    public void testCreatePlainSpec() {
        Model model = TestModelSpec.createPlainModelDesc();
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        this.assertIsoModels(model, modelSpec.getDescription());
        TestModelFactory.assertTrue((boolean)(modelSpec instanceof PlainModelSpec));
        TestModelFactory.assertTrue((boolean)(modelSpec.createModel().getGraph() instanceof GraphMem));
    }

    public void testCreateOntSpec() {
        Resource resource = ResourceFactory.createResource();
        Resource resource2 = ResourceFactory.createResource();
        Resource resource3 = ResourceFactory.createResource();
        OntDocumentManager ontDocumentManager = new OntDocumentManager();
        Resource resource4 = ResourceFactory.createResource("http://jena.hpl.hp.com/2003/DAMLMicroReasonerFactory");
        Model model = ModelFactory.createDefaultModel().add(resource, JMS.importMaker, resource2).add(resource2, RDF.type, JMS.MemMakerSpec).add(resource2, JMS.reificationMode, JMS.rsMinimal).add(resource, JMS.ontLanguage, "http://www.daml.org/2001/03/daml+oil#").add(resource, JMS.docManager, ModelSpecImpl.createValue(ontDocumentManager)).add(resource, JMS.reasonsWith, resource3).add(resource3, JMS.reasoner, resource4);
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        TestModelFactory.assertTrue((boolean)(modelSpec instanceof OntModelSpec));
        this.assertIsoModels(model, modelSpec.getDescription());
        TestModelFactory.assertTrue((boolean)(modelSpec.createModel() instanceof OntModel));
    }

    public void testCreateInfSpec() {
        Model model = TestModelSpec.createInfModelDesc("http://jena.hpl.hp.com/2003/DAMLMicroReasonerFactory");
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        TestModelFactory.assertTrue((boolean)(modelSpec instanceof InfModelSpec));
        this.assertIsoModels(model, modelSpec.getDescription());
        TestModelFactory.assertTrue((boolean)(modelSpec.createModel() instanceof InfModel));
    }

    public void testMFCreate() {
        Model model = TestModelSpec.createPlainModelDesc();
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        Model model2 = ModelFactory.createModel(modelSpec);
    }

    public void testMFCreateNamed() {
        Model model = TestModelSpec.createPlainModelDesc();
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        Model model2 = ModelFactory.createModelOver(modelSpec, "aName");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

