/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.ListIndexException;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.TestList;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;

public class TestList
extends TestCase {
    public static final String NS = "uri:urn:x-rdf:test#";
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestList;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$RDFList;

    public TestList(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("TestList");
        for (int i = 0; i <= 5; ++i) {
            testSuite.addTest((Test)new CountTest(i));
            testSuite.addTest((Test)new TailTest(i));
        }
        testSuite.addTest((Test)new ValidityTest());
        testSuite.addTest((Test)new HeadTest());
        testSuite.addTest((Test)new SetHeadTest());
        testSuite.addTest((Test)new SetTailTest());
        testSuite.addTest((Test)new ConsTest());
        testSuite.addTest((Test)new AddTest());
        testSuite.addTest((Test)new TestListGet());
        testSuite.addTest((Test)new ReplaceTest());
        testSuite.addTest((Test)new IndexTest1());
        testSuite.addTest((Test)new IndexTest2());
        testSuite.addTest((Test)new AppendTest());
        testSuite.addTest((Test)new ConcatenateTest());
        testSuite.addTest((Test)new ConcatenateTest2());
        testSuite.addTest((Test)new ApplyTest());
        testSuite.addTest((Test)new ReduceTest());
        testSuite.addTest((Test)new RemoveTest());
        testSuite.addTest((Test)new Map1Test());
        testSuite.addTest((Test)new ListEqualsTest());
        return testSuite;
    }

    protected static void iteratorTest(Iterator iterator, Object[] objectArray) {
        Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$rdf$model$test$TestList == null ? (class$com$hp$hpl$jena$rdf$model$test$TestList = TestList.class$("com.hp.hpl.jena.rdf.model.test.TestList")) : class$com$hp$hpl$jena$rdf$model$test$TestList));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!arrayList.contains(e)) {
                logger.debug((Object)("TestList - Unexpected iterator result: " + e));
            }
            TestList.assertTrue((String)("Value " + e + " was not expected as a result from this iterator "), (boolean)arrayList.contains(e));
            TestList.assertTrue((String)("Value " + e + " was not removed from the list "), (boolean)arrayList.remove(e));
        }
        if (arrayList.size() != 0) {
            logger.debug((Object)"TestList - Expected iterator results not found");
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                logger.debug((Object)("TestList - missing: " + iterator2.next()));
            }
        }
        TestList.assertEquals((String)"There were expected elements from the iterator that were not found", (int)0, (int)arrayList.size());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class ListEqualsTest
    extends ListTest {
        public ListEqualsTest() {
            super("ListEqualsTest");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            Resource resource = model.getResource(RDF.nil.getURI());
            RDFList rDFList = (RDFList)resource.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource[] resourceArray = new Resource[]{model.createResource("uri:urn:x-rdf:test#a"), model.createResource("uri:urn:x-rdf:test#b"), model.createResource("uri:urn:x-rdf:test#c"), model.createResource("uri:urn:x-rdf:test#d"), model.createResource("uri:urn:x-rdf:test#e")};
            Resource[] resourceArray2 = new Resource[]{model.createResource("uri:urn:x-rdf:test#a"), model.createResource("uri:urn:x-rdf:test#b"), model.createResource("uri:urn:x-rdf:test#c"), model.createResource("uri:urn:x-rdf:test#d"), model.createResource("uri:urn:x-rdf:test#e")};
            Resource[] resourceArray3 = new Resource[]{model.createResource("uri:urn:x-rdf:test#a"), model.createResource("uri:urn:x-rdf:test#b"), model.createResource("uri:urn:x-rdf:test#c"), model.createResource("uri:urn:x-rdf:test#d")};
            Resource[] resourceArray4 = new Resource[]{model.createResource("uri:urn:x-rdf:test#a"), model.createResource("uri:urn:x-rdf:test#b"), model.createResource("uri:urn:x-rdf:test#d"), model.createResource("uri:urn:x-rdf:test#c"), model.createResource("uri:urn:x-rdf:test#e")};
            Resource[] resourceArray5 = new Resource[]{model.createResource("uri:urn:x-rdf:test#a"), model.createResource("uri:urn:x-rdf:test#b"), model.createResource("uri:urn:x-rdf:test#c"), model.createResource("uri:urn:x-rdf:test#D"), model.createResource("uri:urn:x-rdf:test#e")};
            Object[][] objectArrayArray = new Object[][]{{resourceArray, resourceArray2, Boolean.TRUE}, {resourceArray, resourceArray3, Boolean.FALSE}, {resourceArray, resourceArray4, Boolean.FALSE}, {resourceArray, resourceArray5, Boolean.FALSE}, {resourceArray2, resourceArray3, Boolean.FALSE}, {resourceArray2, resourceArray4, Boolean.FALSE}, {resourceArray2, resourceArray5, Boolean.FALSE}, {resourceArray3, resourceArray4, Boolean.FALSE}, {resourceArray3, resourceArray5, Boolean.FALSE}};
            for (int i = 0; i < objectArrayArray.length; ++i) {
                RDFList rDFList2 = rDFList.append(Arrays.asList((Object[])objectArrayArray[i][0]).iterator());
                RDFList rDFList3 = rDFList.append(Arrays.asList((Object[])objectArrayArray[i][1]).iterator());
                boolean bl = (Boolean)objectArrayArray[i][2];
                ListEqualsTest.assertEquals((String)("sameListAs testSpec[" + i + "] incorrect"), (boolean)bl, (boolean)rDFList2.sameListAs(rDFList3));
                ListEqualsTest.assertEquals((String)("sameListAs testSpec[" + i + "] (swapped) incorrect"), (boolean)bl, (boolean)rDFList3.sameListAs(rDFList2));
            }
        }
    }

    protected static class RemoveTest
    extends ListTest {
        public RemoveTest() {
            super("RemoveTest");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            Resource resource = model.getResource(RDF.nil.getURI());
            RDFList rDFList = (RDFList)resource.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            RDFList rDFList2 = (RDFList)resource.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource resource2 = model.createResource("uri:urn:x-rdf:test#x");
            Resource resource3 = model.createResource("uri:urn:x-rdf:test#y");
            Resource resource4 = model.createResource("uri:urn:x-rdf:test#z");
            for (int i = 0; i < 10; ++i) {
                rDFList = rDFList.cons(resource2);
                rDFList2 = rDFList2.cons(resource3);
            }
            while (!rDFList.isEmpty()) {
                rDFList = rDFList.removeHead();
                this.checkValid("removeTest0", rDFList, true);
            }
            rDFList2.removeAll();
            RemoveTest.assertEquals((String)"Model should be empty after deleting two lists", (long)0L, (long)model.size());
            RDFList rDFList3 = ((RDFList)resource.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList)).cons(resource4).cons(resource3).cons(resource2);
            RemoveTest.assertTrue((String)"list should contain x ", (boolean)rDFList3.contains(resource2));
            RemoveTest.assertTrue((String)"list should contain y ", (boolean)rDFList3.contains(resource3));
            RemoveTest.assertTrue((String)"list should contain z ", (boolean)rDFList3.contains(resource4));
            rDFList3 = rDFList3.remove(resource3);
            RemoveTest.assertTrue((String)"list should contain x ", (boolean)rDFList3.contains(resource2));
            RemoveTest.assertTrue((String)"list should contain y ", (!rDFList3.contains(resource3) ? 1 : 0) != 0);
            RemoveTest.assertTrue((String)"list should contain z ", (boolean)rDFList3.contains(resource4));
            rDFList3 = rDFList3.remove(resource2);
            RemoveTest.assertTrue((String)"list should contain x ", (!rDFList3.contains(resource2) ? 1 : 0) != 0);
            RemoveTest.assertTrue((String)"list should contain y ", (!rDFList3.contains(resource3) ? 1 : 0) != 0);
            RemoveTest.assertTrue((String)"list should contain z ", (boolean)rDFList3.contains(resource4));
            rDFList3 = rDFList3.remove(resource4);
            RemoveTest.assertTrue((String)"list should contain x ", (!rDFList3.contains(resource2) ? 1 : 0) != 0);
            RemoveTest.assertTrue((String)"list should contain y ", (!rDFList3.contains(resource3) ? 1 : 0) != 0);
            RemoveTest.assertTrue((String)"list should contain z ", (!rDFList3.contains(resource4) ? 1 : 0) != 0);
            RemoveTest.assertTrue((String)"list should be empty", (boolean)rDFList3.isEmpty());
        }
    }

    protected static class Map1Test
    extends ListTest {
        public Map1Test() {
            super("Map1Test");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/ontology/list5.rdf");
            RDFList rDFList = this.getListRoot(model);
            TestList.iteratorTest(rDFList.mapWith(new Map1(this){
                private final /* synthetic */ Map1Test this$0;
                {
                    this.this$0 = map1Test;
                }

                public Object map1(Object object) {
                    return ((Resource)object).getLocalName();
                }
            }), new Object[]{"a", "b", "c", "d", "e"});
        }
    }

    protected static class ReduceTest
    extends ListTest {
        public ReduceTest() {
            super("ReduceTest");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/ontology/list5.rdf");
            RDFList rDFList = this.getListRoot(model);
            RDFList.ReduceFn reduceFn = new RDFList.ReduceFn(this){
                private final /* synthetic */ ReduceTest this$0;
                {
                    this.this$0 = reduceTest;
                }

                public Object reduce(RDFNode rDFNode, Object object) {
                    return (String)object + ((Resource)rDFNode).getLocalName();
                }
            };
            ReduceTest.assertEquals((String)"Result of reduce should be concatentation of local names", (Object)"abcde", (Object)rDFList.reduce(reduceFn, ""));
        }
    }

    protected static class ApplyTest
    extends ListTest {
        public ApplyTest() {
            super("ApplyTest");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/ontology/list5.rdf");
            RDFList rDFList = this.getListRoot(model);
            class MyApply
            implements RDFList.ApplyFn {
                String collect;
                private final /* synthetic */ ApplyTest this$0;

                MyApply(ApplyTest applyTest) {
                    this.this$0 = applyTest;
                    this.collect = "";
                }

                public void apply(RDFNode rDFNode) {
                    this.collect = this.collect + ((Resource)rDFNode).getLocalName();
                }
            }
            MyApply myApply = new MyApply(this);
            rDFList.apply(myApply);
            ApplyTest.assertEquals((String)"Result of apply should be concatentation of local names", (String)"abcde", (String)myApply.collect);
        }
    }

    protected static class ConcatenateTest2
    extends ListTest {
        public ConcatenateTest2() {
            super("ConcatenateTest2");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/ontology/list5.rdf");
            Resource resource = model.createResource("uri:urn:x-rdf:test#a");
            RDFNode[] rDFNodeArray = new Resource[]{model.createResource("uri:urn:x-rdf:test#b"), model.createResource("uri:urn:x-rdf:test#c"), model.createResource("uri:urn:x-rdf:test#d"), model.createResource("uri:urn:x-rdf:test#e")};
            RDFList rDFList = model.createList().cons(resource);
            RDFList rDFList2 = model.createList(rDFNodeArray);
            rDFList.concatenate(rDFList2);
            this.checkValid("concatTest3", rDFList, true);
            RDFList rDFList3 = this.getListRoot(model);
            ConcatenateTest2.assertTrue((String)"Constructed and loaded lists should be the same", (boolean)rDFList.sameListAs(rDFList3));
        }
    }

    protected static class ConcatenateTest
    extends ListTest {
        public ConcatenateTest() {
            super("ConcatenateTest");
        }

        public void runTest() {
            int n;
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/ontology/list5.rdf");
            Resource resource = model.getResource(RDF.nil.getURI());
            RDFList rDFList = (RDFList)resource.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource resource2 = model.createResource("uri:urn:x-rdf:test#foo");
            for (n = 0; n < 5; ++n) {
                rDFList = rDFList.cons(resource2);
            }
            n = rDFList.size();
            RDFList rDFList2 = this.getListRoot(model);
            int n2 = rDFList2.size();
            rDFList2.concatenate(rDFList);
            this.checkValid("concatTest0", rDFList, true);
            ConcatenateTest.assertEquals((String)"Original list should be unchanged", (int)n, (int)rDFList.size());
            this.checkValid("concatTest1", rDFList2, true);
            ConcatenateTest.assertEquals((String)"Root list should be new length", (int)(n2 + n), (int)rDFList2.size());
        }
    }

    protected static class AppendTest
    extends ListTest {
        public AppendTest() {
            super("AppendTest");
        }

        public void runTest() {
            int n;
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/ontology/list5.rdf");
            Resource resource = model.getResource(RDF.nil.getURI());
            RDFList rDFList = (RDFList)resource.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource resource2 = model.createResource("uri:urn:x-rdf:test#foo");
            for (n = 0; n < 5; ++n) {
                rDFList = rDFList.cons(resource2);
            }
            n = rDFList.size();
            RDFList rDFList2 = this.getListRoot(model);
            int n2 = rDFList2.size();
            RDFList rDFList3 = rDFList2.append(rDFList);
            this.checkValid("appendTest0", rDFList2, true);
            AppendTest.assertEquals((String)"Original list should be unchanged", (int)n2, (int)rDFList2.size());
            this.checkValid("appendTest1", rDFList, true);
            AppendTest.assertEquals((String)"Original list should be unchanged", (int)n, (int)rDFList.size());
            this.checkValid("appendTest2", rDFList3, true);
            AppendTest.assertEquals((String)"Appended list not correct length", (int)(n2 + n), (int)rDFList3.size());
        }
    }

    protected static class IndexTest2
    extends ListTest {
        public IndexTest2() {
            super("IndexTest2");
        }

        public void runTest() {
            int n;
            Model model = ModelFactory.createDefaultModel();
            Resource resource = model.getResource(RDF.nil.getURI());
            RDFList rDFList = (RDFList)resource.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource resource2 = model.createResource("uri:urn:x-rdf:test#a");
            for (n = 0; n < 10; ++n) {
                rDFList = rDFList.cons(resource2);
            }
            for (n = 0; n < 10; ++n) {
                IndexTest2.assertEquals((String)"index of j'th item should be j", (int)n, (int)rDFList.indexOf(resource2, n));
            }
        }
    }

    protected static class IndexTest1
    extends ListTest {
        public IndexTest1() {
            super("IndexTest1");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/ontology/list5.rdf");
            Resource[] resourceArray = new Resource[]{model.createResource("uri:urn:x-rdf:test#a"), model.createResource("uri:urn:x-rdf:test#b"), model.createResource("uri:urn:x-rdf:test#c"), model.createResource("uri:urn:x-rdf:test#d"), model.createResource("uri:urn:x-rdf:test#e")};
            RDFList rDFList = this.getListRoot(model);
            for (int i = 0; i < resourceArray.length; ++i) {
                IndexTest1.assertTrue((String)("list should contain element " + i), (boolean)rDFList.contains(resourceArray[i]));
                IndexTest1.assertEquals((String)("list element " + i + " is not correct"), (int)i, (int)rDFList.indexOf(resourceArray[i]));
            }
        }
    }

    protected static class ReplaceTest
    extends ListTest {
        public ReplaceTest() {
            super("ReplaceTest");
        }

        public void runTest() {
            int n;
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/ontology/list5.rdf");
            Literal[] literalArray = new Literal[]{model.createLiteral("a"), model.createLiteral("b"), model.createLiteral("c"), model.createLiteral("d"), model.createLiteral("e")};
            RDFList rDFList = this.getListRoot(model);
            for (n = 0; n < literalArray.length; ++n) {
                rDFList.replace(n, literalArray[n]);
            }
            for (n = 0; n < literalArray.length; ++n) {
                ReplaceTest.assertEquals((String)("list element " + n + " is not correct"), (Object)literalArray[n], (Object)rDFList.get(n));
            }
            n = 0;
            try {
                rDFList.replace(literalArray.length + 1, literalArray[0]);
            }
            catch (ListIndexException listIndexException) {
                n = 1;
            }
            ReplaceTest.assertTrue((String)"Should see exception raised by accessing beyond end of list", n != 0);
        }
    }

    protected static class TestListGet
    extends ListTest {
        public TestListGet() {
            super("TestListGet");
        }

        public void runTest() {
            int n;
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/ontology/list5.rdf");
            Resource[] resourceArray = new Resource[]{model.createResource("uri:urn:x-rdf:test#a"), model.createResource("uri:urn:x-rdf:test#b"), model.createResource("uri:urn:x-rdf:test#c"), model.createResource("uri:urn:x-rdf:test#d"), model.createResource("uri:urn:x-rdf:test#e")};
            RDFList rDFList = this.getListRoot(model);
            for (n = 0; n < resourceArray.length; ++n) {
                TestListGet.assertEquals((String)("list element " + n + " is not correct"), (Object)resourceArray[n], (Object)rDFList.get(n));
            }
            n = 0;
            try {
                rDFList.get(resourceArray.length + 1);
            }
            catch (ListIndexException listIndexException) {
                n = 1;
            }
            TestListGet.assertTrue((String)"Should see exception raised by accessing beyond end of list", n != 0);
        }
    }

    protected static class AddTest
    extends ListTest {
        public AddTest() {
            super("AddTest");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            Resource resource = model.createResource("uri:urn:x-rdf:test#root");
            Property property = model.createProperty(TestList.NS, "p");
            Resource resource2 = model.getResource(RDF.nil.getURI());
            RDFList rDFList = (RDFList)resource2.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource[] resourceArray = new Resource[]{model.createResource("uri:urn:x-rdf:test#a"), model.createResource("uri:urn:x-rdf:test#b"), model.createResource("uri:urn:x-rdf:test#c"), model.createResource("uri:urn:x-rdf:test#d"), model.createResource("uri:urn:x-rdf:test#e")};
            for (int i = 0; i < resourceArray.length; ++i) {
                RDFList rDFList2 = rDFList.with(resourceArray[i]);
                this.checkValid("addTest0", rDFList2, true);
                AddTest.assertTrue((String)"added'ed lists should be equal", (rDFList.equals(resource2) || rDFList2.equals(rDFList) ? 1 : 0) != 0);
                rDFList = rDFList2;
            }
            model.add(resource, property, rDFList);
            Model model2 = ModelFactory.createDefaultModel();
            model2.read("file:testing/ontology/list5.rdf");
            AddTest.assertTrue((String)"Add'ed and read models should be the same", (boolean)model2.isIsomorphicWith(model));
        }
    }

    protected static class ConsTest
    extends ListTest {
        public ConsTest() {
            super("ConsTest");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            Resource resource = model.createResource("uri:urn:x-rdf:test#root");
            Property property = model.createProperty(TestList.NS, "p");
            Resource resource2 = model.getResource(RDF.nil.getURI());
            RDFList rDFList = (RDFList)resource2.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource[] resourceArray = new Resource[]{model.createResource("uri:urn:x-rdf:test#e"), model.createResource("uri:urn:x-rdf:test#d"), model.createResource("uri:urn:x-rdf:test#c"), model.createResource("uri:urn:x-rdf:test#b"), model.createResource("uri:urn:x-rdf:test#a")};
            for (int i = 0; i < resourceArray.length; ++i) {
                RDFList rDFList2 = rDFList.cons(resourceArray[i]);
                this.checkValid("constest1", rDFList2, true);
                ConsTest.assertTrue((String)"cons'ed lists should not be equal", (!rDFList2.equals(rDFList) ? 1 : 0) != 0);
                rDFList = rDFList2;
            }
            model.add(resource, property, rDFList);
            Model model2 = ModelFactory.createDefaultModel();
            model2.read("file:testing/ontology/list5.rdf");
            ConsTest.assertTrue((String)"Cons'ed and read models should be the same", (boolean)model2.isIsomorphicWith(model));
        }
    }

    protected static class SetTailTest
    extends ListTest {
        public SetTailTest() {
            super("SetTailTest");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            Resource resource = model.createResource("uri:urn:x-rdf:test#root");
            Property property = model.createProperty(TestList.NS, "p");
            Resource resource2 = RDF.nil;
            model.add(resource2, RDF.type, RDF.List);
            Resource resource3 = model.createResource();
            model.add(resource3, RDF.type, RDF.List);
            model.add(resource3, RDF.first, "fred");
            model.add(resource3, RDF.rest, resource2);
            model.add(resource, property, resource3);
            RDFList rDFList = this.getListRoot(model);
            this.checkValid("settail1", rDFList, true);
            Resource resource4 = model.createResource();
            model.add(resource4, RDF.type, RDF.List);
            model.add(resource4, RDF.first, "george");
            model.add(resource4, RDF.rest, resource2);
            RDFList rDFList2 = (RDFList)resource4.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            SetTailTest.assertNotNull((String)"as(RDFList) should not return null for root", (Object)rDFList2);
            this.checkValid("settail2", rDFList2, true);
            SetTailTest.assertEquals((String)"l1 should have length 1", (int)1, (int)rDFList.size());
            SetTailTest.assertEquals((String)"l2 should have length 1", (int)1, (int)rDFList2.size());
            rDFList.setTail(rDFList2);
            this.checkValid("settail3", rDFList, true);
            this.checkValid("settail4", rDFList2, true);
            SetTailTest.assertEquals((String)"l1 should have length 2", (int)2, (int)rDFList.size());
            SetTailTest.assertEquals((String)"l2 should have length 1", (int)1, (int)rDFList2.size());
        }
    }

    protected static class SetHeadTest
    extends ListTest {
        public SetHeadTest() {
            super("SetHeadTest");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            Resource resource = model.createResource("uri:urn:x-rdf:test#root");
            Property property = model.createProperty(TestList.NS, "p");
            Resource resource2 = RDF.nil;
            model.add(resource2, RDF.type, RDF.List);
            Resource resource3 = model.createResource();
            model.add(resource3, RDF.type, RDF.List);
            model.add(resource3, RDF.first, "fred");
            model.add(resource3, RDF.rest, resource2);
            model.add(resource, property, resource3);
            RDFList rDFList = this.getListRoot(model);
            this.checkValid("sethead1", rDFList, true);
            SetHeadTest.assertEquals((String)"List head should be 'fred'", (String)"fred", (String)((Literal)rDFList.getHead()).getString());
            rDFList.setHead(model.createLiteral(42L));
            this.checkValid("sethead2", rDFList, true);
            SetHeadTest.assertEquals((String)"List head should be '42'", (int)42, (int)((Literal)rDFList.getHead()).getInt());
        }
    }

    protected static class TailTest
    extends ListTest {
        protected int i;

        public TailTest(int n) {
            super("TailTest");
            this.i = n;
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/ontology/list" + this.i + ".rdf");
            RDFList rDFList = this.getListRoot(model);
            for (int i = 0; i < this.i; ++i) {
                rDFList = rDFList.getTail();
            }
            TailTest.assertTrue((String)("Should have reached the end of the list after " + this.i + " getTail()'s"), (boolean)rDFList.isEmpty());
        }
    }

    protected static class HeadTest
    extends ListTest {
        public HeadTest() {
            super("HeadTest");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/ontology/list5.rdf");
            RDFList rDFList = this.getListRoot(model);
            String[] stringArray = new String[]{"a", "b", "c", "d", "e"};
            for (int i = 0; i < stringArray.length; ++i) {
                HeadTest.assertEquals((String)"head of list has incorrect URI", (String)(TestList.NS + stringArray[i]), (String)((Resource)rDFList.getHead()).getURI());
                rDFList = rDFList.getTail();
            }
        }
    }

    protected static class ValidityTest
    extends ListTest {
        public ValidityTest() {
            super("ValidityTest");
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            Resource resource = model.createResource("uri:urn:x-rdf:test#root");
            Property property = model.createProperty(TestList.NS, "p");
            Resource resource2 = RDF.nil;
            model.add(resource, property, resource2);
            RDFList rDFList = this.getListRoot(model);
            this.checkValid("valid1", rDFList, true);
            Resource resource3 = model.createResource();
            model.getRequiredProperty(resource, property).remove();
            model.add(resource, property, resource3);
            model.add(resource3, RDF.type, RDF.List);
            RDFList rDFList2 = this.getListRoot(model);
            this.checkValid("valid2", rDFList2, false);
            model.add(resource3, RDF.first, "fred");
            this.checkValid("valid4", rDFList2, false);
            model.add(resource3, RDF.rest, resource2);
            this.checkValid("valid5", rDFList2, true);
        }
    }

    protected static class CountTest
    extends ListTest {
        protected int i;

        public CountTest(int n) {
            super("CountTest");
            this.i = n;
        }

        public void runTest() {
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/ontology/list" + this.i + ".rdf");
            RDFList rDFList = this.getListRoot(model);
            CountTest.assertEquals((String)("List size should be " + this.i), (int)this.i, (int)rDFList.size());
        }
    }

    protected static class ListTest
    extends TestCase {
        public ListTest(String string) {
            super(string);
        }

        protected void checkValid(String string, RDFList rDFList, boolean bl) {
            rDFList.setStrict(true);
            boolean bl2 = rDFList.isValid();
            ListTest.assertEquals((String)("Validity test " + string + " returned wrong isValid() result"), (boolean)bl, (boolean)bl2);
        }

        protected RDFList getListRoot(Model model) {
            Resource resource = model.getResource("uri:urn:x-rdf:test#root");
            ListTest.assertNotNull((String)"Root resource should not be null", (Object)resource);
            Resource resource2 = resource.getRequiredProperty(model.getProperty("uri:urn:x-rdf:test#p")).getResource();
            RDFList rDFList = (RDFList)resource2.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            ListTest.assertNotNull((String)"as(RDFList) should not return null for root", (Object)rDFList);
            return rDFList;
        }
    }
}

