/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;

public class ModelMakerImpl
implements ModelMaker {
    protected GraphMaker maker;
    protected Model description;

    public ModelMakerImpl(GraphMaker graphMaker) {
        this.maker = graphMaker;
    }

    public GraphMaker getGraphMaker() {
        return this.maker;
    }

    public void close() {
        this.maker.close();
    }

    public Model openModel(String string, boolean bl) {
        return new ModelCom(this.maker.openGraph(string, bl));
    }

    public Model openModel(String string) {
        return this.openModel(string, false);
    }

    public Model createModel(String string, boolean bl) {
        return new ModelCom(this.maker.createGraph(string, bl));
    }

    public Model createModel(String string) {
        return this.createModel(string, false);
    }

    public Model createModelOver(String string) {
        return this.createModel(string);
    }

    public Model createModel() {
        return new ModelCom(this.maker.createGraph());
    }

    public Model getModel() {
        return new ModelCom(this.maker.getGraph());
    }

    public Model getDescription() {
        if (this.description == null) {
            this.description = new ModelCom(this.maker.getDescription());
        }
        return this.description;
    }

    public Model getDescription(Resource resource) {
        return new ModelCom(this.maker.getDescription(resource.asNode()));
    }

    public Model addDescription(Model model, Resource resource) {
        return new ModelCom(this.maker.addDescription(model.getGraph(), resource.asNode()));
    }

    public void removeModel(String string) {
        this.maker.removeGraph(string);
    }

    public boolean hasModel(String string) {
        return this.maker.hasGraph(string);
    }
}

