/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.hp.hpl.jena.rdf.model.ModelLock;
import com.hp.hpl.jena.shared.JenaException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModelLockImpl
implements ModelLock {
    public static final boolean DEBUG = false;
    public static final boolean DEBUG_OBJ = true;
    static PrintStream out = System.err;
    Map threadStates = new HashMap();
    int threadStatesSize = this.threadStates.size();
    int LIMIT = 100;
    WriterPreferenceReadWriteLock lock = new WriterPreferenceReadWriteLock();
    SynchronizedInt activeReadLocks = new SynchronizedInt(0);
    SynchronizedInt activeWriteLocks = new SynchronizedInt(0);

    ModelLockImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterCriticalSection(boolean bl) {
        block12: {
            ModelLockState modelLockState = this.getLockState();
            if (modelLockState.readLocks > 0 && modelLockState.writeLocks == 0 && !bl) {
                ModelLockState modelLockState2 = modelLockState;
                synchronized (modelLockState2) {
                    ++modelLockState.readLocks;
                }
                this.activeReadLocks.increment();
                throw new JenaException("enterCriticalSection: Write lock request while holding read lock - potential deadlock");
            }
            if (modelLockState.writeLocks > 0 && bl) {
                bl = false;
            }
            try {
                if (bl) {
                    if (modelLockState.readLocks == 0) {
                        this.lock.readLock().acquire();
                    }
                    ++modelLockState.readLocks;
                    this.activeReadLocks.increment();
                    break block12;
                }
                if (modelLockState.writeLocks == 0) {
                    this.lock.writeLock().acquire();
                }
                ++modelLockState.writeLocks;
                this.activeWriteLocks.increment();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final void leaveCriticalSection() {
        ModelLockState modelLockState = this.getLockState();
        if (modelLockState.readLocks > 0) {
            --modelLockState.readLocks;
            this.activeReadLocks.decrement();
            if (modelLockState.readLocks == 0) {
                this.lock.readLock().release();
            }
            modelLockState.clean();
            return;
        }
        if (modelLockState.writeLocks > 0) {
            --modelLockState.writeLocks;
            this.activeWriteLocks.decrement();
            if (modelLockState.writeLocks == 0) {
                this.lock.writeLock().release();
            }
            modelLockState.clean();
            return;
        }
        throw new JenaException("leaveCriticalSection: No lock held");
    }

    private String report(ModelLockState modelLockState) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Thread R/W: ");
        stringBuffer.append(Integer.toString(modelLockState.readLocks));
        stringBuffer.append("/");
        stringBuffer.append(Integer.toString(modelLockState.writeLocks));
        stringBuffer.append(" :: Model R/W: ");
        stringBuffer.append(Integer.toString(this.activeReadLocks.get()));
        stringBuffer.append("/");
        stringBuffer.append(Integer.toString(this.activeWriteLocks.get()));
        stringBuffer.append(" (lock:");
        stringBuffer.append(this);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    synchronized ModelLockState getLockState() {
        Thread thread = Thread.currentThread();
        ModelLockState modelLockState = (ModelLockState)this.threadStates.get(thread);
        if (modelLockState == null) {
            modelLockState = new ModelLockState(this);
            this.threadStates.put(thread, modelLockState);
            this.threadStatesSize = this.threadStates.size();
        }
        return modelLockState;
    }

    class ModelLockState {
        int readLocks = 0;
        int writeLocks = 0;
        ModelLock modelLock;

        ModelLockState(ModelLock modelLock) {
            this.modelLock = modelLock;
        }

        void clean() {
            if (ModelLockImpl.this.activeReadLocks.get() == 0 && ModelLockImpl.this.activeWriteLocks.get() == 0 && ModelLockImpl.this.threadStatesSize > ModelLockImpl.this.LIMIT) {
                this.clean2();
            }
        }

        private void remove(Thread thread) {
            ModelLockImpl.this.threadStates.remove(thread);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clean2() {
            ModelLock modelLock = this.modelLock;
            synchronized (modelLock) {
                if (ModelLockImpl.this.activeReadLocks.get() != 0 || ModelLockImpl.this.activeWriteLocks.get() != 0) {
                    return;
                }
                int n = 0;
                Iterator iterator = ModelLockImpl.this.threadStates.keySet().iterator();
                while (iterator.hasNext()) {
                    ModelLockState modelLockState = (ModelLockState)iterator.next();
                    if (modelLockState.readLocks != 0 || modelLockState.writeLocks != 0) continue;
                    iterator.remove();
                    ++n;
                }
                if (n < ModelLockImpl.this.LIMIT / 10) {
                    ModelLockImpl.this.LIMIT *= 2;
                }
                ModelLockImpl.this.threadStatesSize = ModelLockImpl.this.threadStates.size();
            }
        }
    }
}

