/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.test.ARPTestInputStreamFactory;
import com.hp.hpl.jena.rdf.arp.test.LazyInputStream;
import com.hp.hpl.jena.rdf.arp.test.URI;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xml.sax.SAXException;

class WGTestSuite
extends TestSuite
implements ARPErrorNumbers {
    public static boolean checkMessages = false;
    private static boolean inDevelopment = false;
    static String testNS = "http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#";
    static String jjcNS = "http://jcarroll.hpl.hp.com/testSchema#";
    private static String approved = "APPROVED";
    private static Property status = new PropertyImpl(testNS, "status");
    private static Property input = new PropertyImpl(testNS, "inputDocument");
    private static Property output = new PropertyImpl(testNS, "outputDocument");
    private static Property warning = new PropertyImpl(testNS, "warning");
    private static Property errorCodes = new PropertyImpl(jjcNS, "error");
    private static Resource rdfxml = new ResourceImpl(testNS, "RDF-XML-Document");
    private static Resource ntriple = new ResourceImpl(testNS, "NT-Document");
    private URI testDir;
    private Act noop = new Act(){

        public void act(Resource resource) {
        }
    };
    ARPTestInputStreamFactory factory;
    private static Collection misc = Arrays.asList("http://www.w3.org/2000/10/rdf-tests/rdfcore/rdfms-uri-substructure/error001");
    private Map behaviours = new HashMap();
    String createMe;
    private ZipFile zip;
    private Map parts;
    static final String[] errorLevelName = new String[]{"warning", "error", "fatal error"};
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$test$WGTestSuite;

    static Reader getReader(String string) throws IOException {
        return new InputStreamReader(WGTestSuite.getInputStream(string), "utf-8");
    }

    static InputStream getInputStream(String string) {
        ClassLoader classLoader = (class$com$hp$hpl$jena$rdf$arp$test$WGTestSuite == null ? (class$com$hp$hpl$jena$rdf$arp$test$WGTestSuite = WGTestSuite.class$("com.hp.hpl.jena.rdf.arp.test.WGTestSuite")) : class$com$hp$hpl$jena$rdf$arp$test$WGTestSuite).getClassLoader();
        if (classLoader == null) {
            throw new SecurityException("Cannot access class loader");
        }
        InputStream inputStream = classLoader.getResourceAsStream("testing/" + string);
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream("testing/" + string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource: " + string + " not found on class path.");
            }
        }
        return inputStream;
    }

    Model loadRDF(InputStream inputStream, RDFErrorHandler rDFErrorHandler, String string) throws IOException {
        ModelMem modelMem = new ModelMem();
        JenaReader jenaReader = new JenaReader();
        if (rDFErrorHandler != null) {
            jenaReader.setErrorHandler(rDFErrorHandler);
        }
        jenaReader.setProperty("error-mode", "strict");
        jenaReader.read((Model)modelMem, inputStream, string);
        inputStream.close();
        return modelMem;
    }

    static Model loadNT(InputStream inputStream, String string) throws IOException {
        ModelMem modelMem = new ModelMem();
        modelMem.read(inputStream, string, "N-TRIPLE");
        inputStream.close();
        return modelMem;
    }

    private Model loadRDF(ARPTestInputStreamFactory aRPTestInputStreamFactory, String string) {
        Model model;
        block5: {
            model = null;
            String string2 = aRPTestInputStreamFactory.getBase().toString();
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            try {
                InputStream inputStream = aRPTestInputStreamFactory.open(string);
                if (inputStream instanceof LazyInputStream && !((LazyInputStream)inputStream).connect()) {
                    return null;
                }
                model = this.loadRDF(inputStream, null, string2 + string);
            }
            catch (JenaException jenaException) {
                throw jenaException;
            }
            catch (Exception exception) {
                if (!string.equals("Manifest.rdf")) break block5;
                System.err.println("Failed to open Manifest.rdf");
                exception.printStackTrace();
            }
        }
        return model;
    }

    WGTestSuite(ARPTestInputStreamFactory aRPTestInputStreamFactory, String string, boolean bl) {
        super(string);
        this.behaviours.put(new ResourceImpl(testNS + "PositiveParserTest"), new Act(){

            public void act(Resource resource) {
                if (resource.hasProperty(warning)) {
                    WGTestSuite.this.addTest(resource, new WarningTest(resource));
                } else {
                    WGTestSuite.this.addTest(resource, new PositiveTest(resource));
                }
            }
        });
        this.behaviours.put(new ResourceImpl(testNS + "NegativeParserTest"), new Act(){

            public void act(Resource resource) {
                WGTestSuite.this.addTest(resource, new NegativeTest(resource));
            }
        });
        this.behaviours.put(new ResourceImpl(testNS + "RDF-XML-Document"), this.noop);
        this.behaviours.put(new ResourceImpl(testNS + "NT-Document"), this.noop);
        this.behaviours.put(new ResourceImpl(testNS + "PositiveEntailmentTest"), this.noop);
        this.behaviours.put(new ResourceImpl(testNS + "NegativeEntailmentTest"), this.noop);
        this.behaviours.put(new ResourceImpl(testNS + "MiscellaneousTest"), new Act(){

            public void act(Resource resource) {
                String string = resource.getURI();
                if (!misc.contains(string)) {
                    System.err.println("MiscellaneousTest: " + string + " - ignored!");
                }
            }
        });
        this.parts = new HashMap();
        this.factory = aRPTestInputStreamFactory;
        this.testDir = aRPTestInputStreamFactory.getBase();
        if (bl) {
            try {
                this.createMe = "new " + this.getClass().getName() + "(" + aRPTestInputStreamFactory.createMe + ", \"" + string + "\", false )";
                Model model = this.loadRDF(aRPTestInputStreamFactory, "Manifest.rdf");
                Model model2 = this.loadRDF(aRPTestInputStreamFactory, "Manifest-extra.rdf");
                Model model3 = this.loadRDF(aRPTestInputStreamFactory, "Manifest-wrong.rdf");
                if (model2 != null) {
                    model = model.add(model2);
                }
                if (model3 != null) {
                    model = model.difference(model3);
                }
                StmtIterator stmtIterator = model.listStatements(null, RDF.type, (RDFNode)null);
                while (stmtIterator.hasNext()) {
                    Statement statement = stmtIterator.nextStatement();
                    Act act = (Act)this.behaviours.get(statement.getObject());
                    if (act == null) {
                        System.err.println("Unknown test class: " + ((Resource)statement.getObject()).getURI());
                        continue;
                    }
                    act.act(statement.getSubject());
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                throw runtimeException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new JenaException(exception);
            }
        }
    }

    static TestSuite suite(URI uRI, String string, String string2) {
        return new WGTestSuite(new ARPTestInputStreamFactory(uRI, string), string2, true);
    }

    static TestSuite suite(URI uRI, URI uRI2, String string) {
        return new WGTestSuite(new ARPTestInputStreamFactory(uRI, uRI2), string, true);
    }

    private void addTest(Resource resource, TestCase testCase) {
        String string = resource.hasProperty(status) ? resource.getRequiredProperty(status).getString() : "no status";
        TestSuite testSuite = (TestSuite)this.parts.get(string);
        if (testSuite == null) {
            if (string.equals("OBSOLETED")) {
                return;
            }
            testSuite = new TestSuite();
            testSuite.setName(string);
            this.parts.put(string, testSuite);
            this.addTest((junit.framework.Test)testSuite);
        }
        testSuite.addTest((junit.framework.Test)testCase);
    }

    TestCase createPositiveTest(String string, String string2, boolean bl, String string3, boolean bl2) {
        return new PositiveTest2(string, string2, bl, string3, bl2);
    }

    TestCase createWarningTest(String string, String string2, boolean bl, String string3, boolean bl2, int[] nArray) {
        return new WarningTest2(string, string2, bl, string3, bl2, nArray);
    }

    TestCase createNegativeTest(String string, String string2, boolean bl, int[] nArray) {
        return new NegativeTest2(string, string2, bl, nArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class NegativeTest2
    extends Test2 {
        Model m1;
        Set expected;
        int expectedLevel = 1;
        String in;
        boolean intype;
        private Set found = new HashSet();
        private int[] errorCnt = new int[]{0, 0, 0};

        NegativeTest2(String string, String string2, boolean bl, int[] nArray) {
            super(string);
            this.in = string2;
            this.intype = bl;
            this.initExpected(nArray);
        }

        void initExpected(int[] nArray) {
            if (nArray == null) {
                return;
            }
            if (nArray.length != 0) {
                this.expected = new HashSet();
            }
            for (int i = 0; i < nArray.length; ++i) {
                this.expected.add(new Integer(nArray[i]));
            }
        }

        protected void runTest() {
            try {
                this.m1 = this.read(this.in, this.intype);
            }
            catch (JenaException jenaException) {
                if (!(jenaException.getCause() instanceof SAXException)) {
                    NegativeTest2.fail((String)jenaException.getMessage());
                }
            }
            catch (IOException iOException) {
                NegativeTest2.fail((String)iOException.getMessage());
            }
            if (this.expected != null && !((Object)this.expected).equals(this.found)) {
                HashSet hashSet = new HashSet();
                hashSet.addAll(this.found);
                hashSet.removeAll(this.expected);
                this.expected.removeAll(this.found);
                Iterator iterator = this.expected.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    String string = "Expected error  " + JenaReader.errorCodeName(n) + ", was not detected.";
                    if (this.errorCnt[2] == 0) {
                        NegativeTest2.fail((String)string);
                        continue;
                    }
                    System.err.println("Test: " + this.getName());
                    System.err.println(string);
                }
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    NegativeTest2.fail((String)("Detected error  " + JenaReader.errorCodeName((Integer)iterator.next()) + ", was not expected."));
                }
            }
            for (int i = 2; i >= 0; --i) {
                if (i == this.expectedLevel) {
                    if (this.errorCnt[i] != 0 || i == 1 && this.errorCnt[2] != 0) continue;
                    NegativeTest2.fail((String)("No " + errorLevelName[this.expectedLevel] + " in input file of class " + this.getClass().getName()));
                    continue;
                }
                if (this.expected != null || this.errorCnt[i] == 0) continue;
                NegativeTest2.fail((String)("Inappropriate " + errorLevelName[i] + " in input file of class " + this.getClass().getName()));
            }
        }

        void onError(int n, int n2) {
            Integer n4 = new Integer(n2);
            this.found.add(n4);
            int n5 = n;
            this.errorCnt[n5] = this.errorCnt[n5] + 1;
            if (this.expected != null && !this.expected.contains(n4)) {
                super.onError(n, n2);
            }
        }
    }

    class WarningTest2
    extends PositiveTest2 {
        WarningTest2(String string, String string2, boolean bl, String string3, boolean bl2, int[] nArray) {
            super(string, string2, bl, string3, bl2, nArray);
            this.expectedLevel = 0;
        }
    }

    class PositiveTest2
    extends NegativeTest2 {
        String out;
        boolean outtype;

        PositiveTest2(String string, String string2, boolean bl, String string3, boolean bl2) {
            this(string, string2, bl, string3, bl2, new int[0]);
        }

        PositiveTest2(String string, String string2, boolean bl, String string3, boolean bl2, int[] nArray) {
            super(string, string2, bl, nArray);
            this.expectedLevel = -1;
            this.out = string3;
            this.outtype = bl2;
        }

        protected void runTest() {
            try {
                Model model = this.read(this.out, this.outtype);
                super.runTest();
                if (!this.m1.isIsomorphicWith(model)) {
                    System.err.println("=====");
                    this.m1.write(System.err, "N-TRIPLE");
                    System.err.println("=====");
                    model.write(System.err, "N-TRIPLE");
                    System.err.println("=====");
                    PositiveTest2.fail((String)"Models were not equal.");
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                PositiveTest2.fail((String)exception.getMessage());
            }
        }

        void initExpected() {
            this.expected = new HashSet();
        }
    }

    class Test2
    extends TestCase
    implements RDFErrorHandler {
        Test2(String string) {
            super(WGTestSuite.this.testDir.relativize(URI.create(string)).toString());
        }

        Model read(String string, boolean bl) throws IOException {
            if (!bl) {
                return WGTestSuite.loadNT(WGTestSuite.this.factory.open(string), string);
            }
            String string2 = string;
            return WGTestSuite.this.loadRDF(WGTestSuite.this.factory.open(string2), this, string2);
        }

        public void warning(Exception exception) {
            this.error(0, exception);
        }

        public void error(Exception exception) {
            this.error(1, exception);
        }

        public void fatalError(Exception exception) {
            this.error(2, exception);
        }

        private void error(int n, Exception exception) {
            if (exception instanceof ParseException) {
                String string;
                int n2 = ((ParseException)exception).getErrorNumber();
                if (n2 == 201 && ((string = exception.getMessage()).indexOf("Unusual") != -1 || string.indexOf("Internal") != -1)) {
                    System.err.println(this.getName());
                    System.err.println(string);
                    Test2.fail((String)string);
                }
                this.onError(n, n2);
            } else if (exception instanceof SAXException) {
                Test2.fail((String)("Not expecting a SAXException: " + exception.getMessage()));
            } else {
                Test2.fail((String)("Not expecting an Exception: " + exception.getMessage()));
            }
        }

        private void println(String string) {
            System.err.println(string);
        }

        void onError(int n, int n2) {
            String string = "Parser reports unexpected " + errorLevelName[n] + ": " + JenaReader.errorCodeName(n2);
            this.println(string);
            Test2.fail((String)string);
        }
    }

    class NegativeTest
    extends Test {
        Model m1;
        Set expected;
        int expectedLevel = 1;
        private Set found = new HashSet();
        private int[] errorCnt = new int[]{0, 0, 0};

        String createExpected() {
            String string = "new int[]{";
            if (this.expected == null) {
                return "null";
            }
            Iterator iterator = this.expected.iterator();
            while (iterator.hasNext()) {
                string = string + iterator.next() + ", ";
            }
            return string + "}";
        }

        String createMe() {
            return this.createURI() + "," + this.create(input) + "," + this.createExpected();
        }

        NegativeTest(Resource resource) {
            super(resource);
            this.initExpected();
        }

        void save(Property property) {
            if (WGTestSuite.this.factory.savable()) {
                String string = this.testID.getRequiredProperty(property).getResource().getURI();
                int n = string.lastIndexOf(46);
                String string2 = string.substring(0, n) + ".ntx";
                try {
                    OutputStream outputStream = WGTestSuite.this.factory.openOutput(string2);
                    this.m1.write(outputStream, "N-TRIPLE");
                    outputStream.close();
                }
                catch (IOException iOException) {
                    throw new JenaException(iOException);
                }
            }
        }

        void initExpectedFromModel() {
            StmtIterator stmtIterator = this.testID.listProperties(errorCodes);
            if (stmtIterator.hasNext()) {
                this.expected = new HashSet();
                while (stmtIterator.hasNext()) {
                    String string = stmtIterator.nextStatement().getResource().getURI();
                    String string2 = string.substring(string.lastIndexOf(35) + 1);
                    this.expected.add(new Integer(JenaReader.errorCode(string2)));
                }
            }
        }

        void initExpected() {
            this.initExpectedFromModel();
        }

        protected void runTest() {
            try {
                this.m1 = this.read(input);
                if (this.expectedLevel == 1 && this.expected == null && this.errorCnt[2] == 0 && this.errorCnt[1] == 0) {
                    this.save(input);
                }
            }
            catch (JenaException jenaException) {
                if (!(jenaException.getCause() instanceof SAXException)) {
                    NegativeTest.fail((String)jenaException.getMessage());
                }
            }
            catch (IOException iOException) {
                NegativeTest.fail((String)iOException.getMessage());
            }
            if (this.expected != null && !((Object)this.expected).equals(this.found)) {
                HashSet hashSet = new HashSet();
                hashSet.addAll(this.found);
                hashSet.removeAll(this.expected);
                this.expected.removeAll(this.found);
                Iterator iterator = this.expected.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    String string = "Expected error  " + JenaReader.errorCodeName(n) + ", was not detected.";
                    if (this.errorCnt[2] == 0) {
                        NegativeTest.fail((String)string);
                        continue;
                    }
                    if (n == 201 && this.getName().startsWith("rdf-nnn/67_") && "1234".indexOf(this.getName().charAt("rdf-nnn/67_".length())) != -1) continue;
                    System.err.println("Test: " + this.getName());
                    System.err.println(string);
                }
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    NegativeTest.fail((String)("Detected error  " + JenaReader.errorCodeName((Integer)iterator.next()) + ", was not expected."));
                }
            }
            for (int i = 2; i >= 0; --i) {
                if (i == this.expectedLevel) {
                    if (this.errorCnt[i] != 0 || i == 1 && this.errorCnt[2] != 0) continue;
                    NegativeTest.fail((String)("No " + errorLevelName[this.expectedLevel] + " in input file of class " + this.getClass().getName()));
                    continue;
                }
                if (this.expected != null || this.errorCnt[i] == 0) continue;
                NegativeTest.fail((String)("Inappropriate " + errorLevelName[i] + " in input file of class " + this.getClass().getName()));
            }
        }

        void onError(int n, int n2) {
            Integer n4 = new Integer(n2);
            this.found.add(n4);
            int n5 = n;
            this.errorCnt[n5] = this.errorCnt[n5] + 1;
            if (this.expected != null) {
                if (!this.expected.contains(n4)) {
                    super.onError(n, n2);
                }
            } else if (inDevelopment) {
                System.err.println("<rdf:Description rdf:about='" + this.testID.getURI() + "'>\n" + "<jjc:error rdf:resource='" + jjcNS + JenaReader.errorCodeName(n2) + "'/>\n</rdf:Description>");
            }
        }
    }

    class WarningTest
    extends PositiveTest {
        String createMe() {
            return this.createURI() + "," + this.create(input) + "," + this.create(output) + "," + this.createExpected();
        }

        WarningTest(Resource resource) {
            super(resource);
            this.expectedLevel = 0;
        }

        void initExpected() {
            this.initExpectedFromModel();
        }
    }

    class PositiveTest
    extends NegativeTest {
        String createMe() {
            return this.createURI() + "," + this.create(input) + "," + this.create(output);
        }

        PositiveTest(Resource resource) {
            super(resource);
            this.expectedLevel = -1;
        }

        protected void runTest() {
            try {
                Model model = this.read(output);
                super.runTest();
                if (!((Object)this.m1).equals(model)) {
                    this.save(output);
                    PositiveTest.assertEquals((Object)this.m1, (Object)model);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                PositiveTest.fail((String)exception.getMessage());
            }
        }

        void initExpected() {
            this.expected = new HashSet();
        }
    }

    abstract class Test
    extends TestCase
    implements RDFErrorHandler {
        Resource testID;

        String createURI() {
            return "\"" + this.testID.getURI() + "\"";
        }

        abstract String createMe();

        Test(Resource resource) {
            super(WGTestSuite.this.testDir.relativize(URI.create(resource.getURI())).toString());
            this.testID = resource;
        }

        String create(Property property) {
            Resource resource = this.testID.getRequiredProperty(property).getResource();
            Resource resource2 = resource.getRequiredProperty(RDF.type).getResource();
            if (((Object)ntriple).equals(resource2)) {
                return "\"" + resource.getURI() + "\",false";
            }
            if (((Object)rdfxml).equals(resource2)) {
                return "\"" + resource.getURI() + "\",true";
            }
            return "Unrecognized file type: " + resource2;
        }

        Model read(Property property) throws IOException {
            Resource resource = this.testID.getRequiredProperty(property).getResource();
            Resource resource2 = resource.getRequiredProperty(RDF.type).getResource();
            String string = resource.getURI();
            if (((Object)ntriple).equals(resource2)) {
                return WGTestSuite.loadNT(WGTestSuite.this.factory.open(string), string);
            }
            if (((Object)rdfxml).equals(resource2)) {
                return WGTestSuite.this.loadRDF(WGTestSuite.this.factory.open(string), this, string);
            }
            Test.fail((String)("Unrecognized file type: " + resource2));
            return null;
        }

        public void warning(Exception exception) {
            this.error(0, exception);
        }

        public void error(Exception exception) {
            this.error(1, exception);
        }

        public void fatalError(Exception exception) {
            this.error(2, exception);
        }

        private void error(int n, Exception exception) {
            if (exception instanceof ParseException) {
                int n2 = ((ParseException)exception).getErrorNumber();
                if (n2 == 201) {
                    String string = exception.getMessage();
                    if (string.indexOf("Unusual") != -1 || string.indexOf("Internal") != -1) {
                        System.err.println(this.testID.getURI());
                        System.err.println(string);
                        Test.fail((String)string);
                    }
                    if (checkMessages) {
                        System.err.println(this.testID.getURI());
                        System.err.println(string);
                    }
                }
                this.onError(n, n2);
            } else if (exception instanceof SAXException) {
                Test.fail((String)("Not expecting a SAXException: " + exception.getMessage()));
            } else {
                Test.fail((String)("Not expecting an Exception: " + exception.getMessage()));
            }
        }

        private void println(String string) {
            System.err.println(string);
        }

        void onError(int n, int n2) {
            String string = "Parser reports unexpected " + errorLevelName[n] + ": " + JenaReader.errorCodeName(n2);
            this.println(string);
            Test.fail((String)string);
        }
    }

    static interface Act {
        public void act(Resource var1);
    }
}

