/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.impl.DBQuery;
import com.hp.hpl.jena.db.impl.DBQueryHandler;
import com.hp.hpl.jena.db.impl.DBQueryStageCompiler;
import com.hp.hpl.jena.db.impl.ResultSetIterator;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.shared.JenaException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class DBQueryStage
extends Stage {
    protected Graph graph;
    protected DBQuery compiled;
    private static final DBQueryStageCompiler compiler = new DBQueryStageCompiler();

    public DBQueryStage(GraphRDB graphRDB, SpecializedGraph specializedGraph, List list, List list2, Graph graph) {
        this.graph = graphRDB;
        this.compiled = this.compile(specializedGraph, list, list2, graph);
    }

    protected DBQuery compile(SpecializedGraph specializedGraph, List list, List list2, Graph graph) {
        return this.compile(compiler, specializedGraph, list, list2, graph);
    }

    protected DBQuery compile(DBQueryStageCompiler dBQueryStageCompiler, SpecializedGraph specializedGraph, List list, List list2, Graph graph) {
        return DBQueryStageCompiler.compile(dBQueryStageCompiler, (DBQueryHandler)this.graph.queryHandler(), specializedGraph, list, list2, graph);
    }

    protected void run(Pipe pipe, Pipe pipe2) {
        IDBConnection iDBConnection = this.compiled.driver.getConnection();
        while (pipe.hasNext()) {
            PreparedStatement preparedStatement;
            Domain domain = pipe.get();
            try {
                preparedStatement = iDBConnection.getConnection().prepareStatement(this.compiled.stmt);
                this.setArgs(domain, preparedStatement);
            }
            catch (Exception exception) {
                throw new JenaException("Query prepare failed: " + exception);
            }
            try {
                ResultSetIterator resultSetIterator = new ResultSetIterator();
                preparedStatement.execute();
                ResultSet resultSet = preparedStatement.getResultSet();
                resultSetIterator.reset(resultSet, preparedStatement, null, null);
                while (resultSetIterator.hasNext()) {
                    Domain domain2 = domain.copy();
                    List list = (List)resultSetIterator.next();
                    for (int i = 0; i < this.compiled.resList.length; ++i) {
                        int n = this.compiled.resList[i];
                        String string = (String)list.get(i);
                        Node node = this.compiled.driver.RDBStringToNode(string);
                        domain2.setElement(n, node);
                    }
                    pipe2.put(domain2);
                }
                resultSetIterator.close();
                preparedStatement.close();
            }
            catch (Exception exception) {
                throw new JenaException("Query execute failed: " + exception);
            }
        }
        pipe2.close();
    }

    protected void setArgs(Domain domain, PreparedStatement preparedStatement) {
        try {
            for (int i = 0; i < this.compiled.argCnt; ++i) {
                int n = (Integer)this.compiled.argIndex.get(i);
                Node node = (Node)domain.get(n);
                if (node == null) {
                    throw new JenaException("Null query argument");
                }
                String string = this.compiled.driver.nodeToRDBString(node, false);
                preparedStatement.setString(i + 1, string);
            }
        }
        catch (Exception exception) {
            throw new JenaException("Bad query argument: " + exception);
        }
    }

    public Pipe deliver(final Pipe pipe) {
        final Pipe pipe2 = this.previous.deliver(new BufferPipe());
        new Thread(){

            public void run() {
                DBQueryStage.this.run(pipe2, pipe);
            }
        }.start();
        return pipe;
    }
}

