/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Apr 24 17:58:27 2001 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.util.lisp;

import junit.framework.*;

/**
 * Lisp reader test cases.
 */
public class LispReadTest extends TestCase {

    public LispReadTest(String name) {
	super(name);
    }

    public void testSymbolReading() {
	assertTrue(Lisp.readFromString("apple") instanceof Symbol);
	assertTrue(Lisp.readFromString(":apple") instanceof Keyword);
	assertTrue(Lisp.readFromString("?apple") instanceof ItemVar);
    }

    public void testNumberReading() {
	Object l = Lisp.readFromString("123");
	Object f = Lisp.readFromString("1.23");
	assertTrue(l instanceof Long);
	assertTrue(f instanceof Double);
	assertEquals(123, ((Long)l).longValue());
	assertEquals(1.23, (((Double)f).doubleValue()), 0.0);
    }

    public void testSignedNumberReading() {
	// /\/: "+123" reads as a Double
	Long nl = (Long)Lisp.readFromString("-123");
	// Long pl = (Long)Lisp.readFromString("+123");
	Double nf = (Double)Lisp.readFromString("-1.23");
	Double pf = (Double)Lisp.readFromString("+1.23");
	assertEquals(-123, nl.longValue());
	// assertEquals(+123, pl.longValue());
	assertEquals(-1.23, nf.doubleValue(), 0.0);
	assertEquals(+1.23, pf.doubleValue(), 0.0);
    }

    public void testNullReading() {
	Object n1 = Lisp.readFromString("()");
	Object n2 = Lisp.readFromString("nil");
	assertTrue(n1 instanceof Null);
	assertTrue(n2 instanceof Null);
	assertTrue(n1 == n2);
    }

    public void testLListReading() {
	assertEquals(Lisp.list(Symbol.intern("a")),
		     Lisp.readFromString("(a)"));
	assertEquals(Lisp.list(Symbol.intern("a"),
			       Symbol.intern("b"), 
			       Symbol.intern("c")),
		     Lisp.readFromString("(a b c)"));
	assertEquals(Lisp.list(Symbol.intern("a"),
			       new Long(1),
			       "b",
			       new Double(2.0)),
		     Lisp.readFromString("(a 1 \"b\" 2.0)"));
    }

}

