/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import junit.framework.*;
import ix.util.Parameters;

/**
 * Test suite that includes all tests for the ix.util.context package.
 */
public class AllTests {

    public static void main(String[] argv) {
	Parameters.processCommandLineArguments(argv);
        junit.textui.TestRunner.run(suite());
    }

    public static Test suite () {
        TestSuite suite = new TestSuite("ix.util.context tests");
	suite.addTest(new TestSuite(RootContextTest.class));
	suite.addTest(new TestSuite(BasicContextTest.class));
	suite.addTest(new TestSuite(ContextHoldingStrategyTest.class));
	suite.addTest(new TestSuite(LLQueueTest.class));
	suite.addTest(new TestSuite(LLQueueContextTest.class));
	suite.addTest(new TestSuite(ContextHashMapTest.class));
	suite.addTest(new TestSuite(ContextHashMapContextTest.class));
	suite.addTest(new TestSuite(ContextGensymContextTest.class));
	return suite;
    }

}
