/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Sep 21 23:13:46 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

import junit.framework.*;

/**
 * Map test cases.
 */
public abstract class AbstractMapTest extends TestCase {

    public AbstractMapTest(String name) {
	super(name);
    }

    protected abstract Map makeMap();

    protected abstract Map makeMap(Map m);

    public void testEmptyMap() {
	// The Map
	Map m = makeMap();
	assertTrue(m.isEmpty());
	assertEquals(0, m.size());
	// The entrySet
	Set e = m.entrySet();
	assertTrue(e.isEmpty());
	assertEquals(0, e.size());
	// The entrySet iterator
	assertFalse(e.iterator().hasNext());
    }

    public void testOneEntryMap() {
	// The Map
	Map m = makeMap();
	m.put("apple", "red");
	assertEquals("red", m.get("apple"));
	assertFalse(m.isEmpty());
	assertEquals(1, m.size());
	// The entrySet
	Set e = m.entrySet();
	assertFalse(e.isEmpty());
	assertEquals(1, e.size());
	// The entrySet iterator
	Iterator i = e.iterator();
	assertTrue(i.hasNext());
	Map.Entry ent = (Map.Entry)i.next();
	assertFalse(i.hasNext());
	// The first Map.Entry
	assertEquals("apple", ent.getKey());
	assertEquals("red", ent.getValue());
    }

    public void testKeysWithoutValues() {
	Map m = makeMap();
	assertNull(m.get("apple"));
	m.put("apple", "red");
	assertEquals("red", m.get("apple"));
	assertNull(m.get("grass"));
	assertNull(m.get("sky"));
    }

    public void testRepeatedHasNext() {
	Map m = make3EntryMap();
	Iterator i = m.entrySet().iterator();
	assertTrue(i.hasNext());
	assertTrue(i.hasNext());
	assertTrue(i.hasNext());
	i.next();
	assertTrue(i.hasNext());
	assertTrue(i.hasNext());
	assertTrue(i.hasNext());
	i.next();
	assertTrue(i.hasNext());
	assertTrue(i.hasNext());
	assertTrue(i.hasNext());
	i.next();
	assertFalse(i.hasNext());
	assertFalse(i.hasNext());
	assertFalse(i.hasNext());
    }

    public void testRepeatedNextWithoutHasNext() {
	Map m = make3EntryMap();
	Iterator i = m.entrySet().iterator();
	i.next();
	i.next();
	i.next();
	assertFalse(i.hasNext());
    }

    public void testSimpleIteration() {
	Map m = make3EntryMap();
	int count = 0;
	for (Iterator i = m.entrySet().iterator(); i.hasNext();) {
	    Map.Entry e = (Map.Entry)i.next();
	    count++;
	}
	assertEquals(3, count);
    }

    public void testMapArgConstructor() {
	// Of course, makeMap(Map) might not call that constructor.
	Map m = make3EntryMap();
	assertEquals(m, makeMap(m));
    }

    protected Map make3EntryMap() {
	Map m = makeMap();
	m.put("apple", "red");
	m.put("grass", "green");
	m.put("snow", "white");
	return m;
    }
}
