;;; Tests that we can generate object names.

(refinement test1 (test1)
  (variables ?food)
  (constraints
    (world-state effect (filling ?food) = apple))
  (annotations
    (output-objects = ((?food pie)))))

(refinement test2 (test2)
  ;; This time, we use an expansion
  (variables ?pie)
  (nodes
    (1 (generate_pie ?pie))))

(refinement test3 (test3)
  ;; This time, no object can be generated, because an object,
  ;; apple-pie-1, is specified.  So no plan can be found.
  ;; We used to let this case work, but the way it worked
  ;; also let other cases work that shouldn't, in particular
  ;; when one condition bound a variable that was meant to
  ;; be bound to a generated object so that several conditions
  ;; could be satisfied.  For example, suppose some object has
  ;; the right type initially, but an object should be generated
  ;; that has the type plus other properties.  An output-generating
  ;; refinement will be brought in to create that new object,
  ;; to satisfy the type constraint plus the other-property ones.
  ;; However, the type constraint might bind to the existing
  ;; object, and that will be given to the generating refinement
  ;; by the other-property conditions.  So instead of generating
  ;; a new object, it will give the existing one additional
  ;; properties.  The change was to stop output-generating refinements
  ;; from using existing values for the output vars.  The vars
  ;; now have to be bound to generated values.
  (nodes
    (1 (generate_pie apple-pie-1))))

(refinement test4 (test4)
  ;; Get the object via a condition.
  (variables ?pie)
  (constraints
    (world-state condition (type ?pie) = pie)))

(refinement generate_pie (generate_pie ?pie)
  (variables ?pie)
  (constraints
    (world-state effect (type ?pie) = pie))
  (annotations
    (output-objects = ((?pie pie)))))

;;; End
