;;; One-refinement version of iglobe-phase1-refinements.lsp

;;; Author: Jeff Dalton
;;; Updated: Thu May 17 03:39:13 2007 by Jeff Dalton

(refinement deal-with-accident-with-injury
	    (deal-with-accident ?number-injured ?location)
  (variables ?number-injured ?location
	     ?medical ?security ?transport)
  (nodes
    (1 (transport 1 ?medical ?location))
    (2 (transport 1 ?security ?location))
    (3 (transport 1 ?transport ?location))
    (4 (transport ?number-injured injured-person hospital)))
  (orderings
    ((1 2 3) 4))
  (constraints
    (compute multiple-answer
      (identity (doctor paramedic))
      = ?medical)
    (compute multiple-answer
      (identity (police-team))
      = ?security)
    (compute multiple-answer
      (identity (ambulance truck))
      = ?transport)
    (resource consume (?medical) = 1)
    (resource consume (?security) = 1)
    (resource consume (?transport) = 1)))

;;; End
