;;; Compute-with-conditions-tests
;;; Author: Jeff Dalton
;;; Updated: Tue Feb  6 16:49:28 2007 by Jeff Dalton

;;; This is partly based on binding-constraint-test.

;;; Tests whether constraints from several conditions, world-state
;;; and compute, can collectively determine a value.  There is
;;; only one yellow fruit with size = 1 and one with size = 2.

(annotations
  (achievable-world-state-conditions = :none))

;;; test1 has only 1 solution

(refinement test1 (test1)
  (nodes
    (0 (setup))
    (1 (require1)))
  (orderings
    (0 1)))

(refinement setup (setup)
  (constraints
    (world-state effect (colour lemon) = yellow)
    (world-state effect (colour sun) = yellow)
    (world-state effect (colour banana) = yellow)
    (world-state effect (type lemon) = fruit)
    (world-state effect (type sun) = star)
    (world-state effect (type banana) = fruit)
    (world-state effect (size lemon) = 1)
    (world-state effect (size sun) = 10000000)
    (world-state effect (size banana) = 2)))

(refinement require1 (require1)
  (variables ?object ?size)
  (constraints
    (world-state condition (colour ?object) = yellow)
    (world-state condition (type ?object) = fruit)
    (world-state condition (size ?object) = ?size)
    (compute (< ?size 2) = true)))  ; only 1 solution

;;; test2 has 2 solutions because there are two different
;;; ways to successfully bind ?f1 and ?f2.  (The values
;;; are just swapped in the second one.)

(refinement test2 (test2)
  (nodes
    (0 (setup))
    (1 (require2)))
  (orderings
    (0 1)))

(refinement require2 (require2)
  (variables ?f1 ?f2 ?s1 ?s2)
  (constraints
    (world-state condition (type ?f1) = fruit)
    (world-state condition (type ?f2) = fruit)
    (compute (eq ?f1 ?f2) = false)
    (world-state condition (size ?f1) = ?s1)
    (world-state condition (size ?f2) = ?s2)
    (compute (+ ?s1 ?s2) = 3)))

;;; test3 is like test2 but with PSVs for ?f1 and ?f2.
;;; Note that this also lets us see the values in the
;;; pattern for (require3 ?fruit1 ?fruit2) once the plan
;;; is complete.

(refinement test3 (test3)
  (variables ?fruit1 ?fruit2)
  (nodes
    (0 (setup))
    (1 (require3 ?fruit1 ?fruit2)))
  (orderings
    (0 1)))

(refinement require3 (require3 ?f1 ?f2)
  (variables ?f1 ?f2 ?s1 ?s2)
  (constraints
    (world-state condition (type ?f1) = fruit)
    (world-state condition (type ?f2) = fruit)
    (compute (eq ?f1 ?f2) = false)
    (world-state condition (size ?f1) = ?s1)
    (world-state condition (size ?f2) = ?s2)
    (compute (+ ?s1 ?s2) = 3)))

;;; End
