;;; Tests what happens when an activity can be expanded in two ways,
;;; but only one of them requires an achieve.  Before November 1, 2004,
;;; the Slip algorithm would not consider the refinement that
;;; could not be used without achieving a cond.

;;; The test is an activity such as (locate isolated-personnel).
;;; There should be two plans, one using locate-somehow, then
;;; another using locate-by-asking.

(refinement locate-by-asking (locate ?ip)
  (variables ?ip)
  (nodes
    (1 (ask ?ip for their location)))
  (constraints
    (world-state condition (communication-status ?ip) = two-way)
    (world-state effect (location-status ?ip) = known)))

(refinement locate-somehow (locate ?ip)
  ;; Having this refinement, which can always be used, stopped
  ;; it from trying locate-by-asking, even though locate-by-asking
  ;; could be used by achieving the communication-status cond.
  (variables ?ip)
  (nodes
    (1 (locate-somehow ?ip)))
  (constraints
    (world-state effect (location-status ?ip) = known)))

(refinement establish-communication (establish-communication-with ?ip)
  (variables ?ip)
  (constraints
    (world-state effect (communication-status ?ip) = two-way)))

(annotations
  (achievable-world-state-conditions =
    (communication-status)))

;;; End
