;;; Test what happens when two conditions can be satisfied individually
;;; but not together, and each condition could be satisfied by introducing
;;; a node.

(refinement test1 (test1)
  (nodes
    (1 (setup))
    (2 (require)))
  (orderings
    (1 2)))

(refinement setup (setup)
  (constraints
    ;; Set up small green leaf and large red apple.
    (world-state effect (colour leaf) = green)
    (world-state effect (colour apple) = red)
    (world-state effect (size leaf) = small)
    (world-state effect (size apple) = large))
  (annotations
    ;; Keep this refinement from being used to achieve a condition.
    (use-for-world-state-effects = :none)))

(refinement require (require)
  (variables ?x)
  (constraints
    ;; Require a small red thing.  Either the leaf can change colour
    ;; or the apple can change size.  So there are two solutions.
    (world-state condition (colour ?x) = red)
    (world-state condition (size ?x) = small)))

(refinement repaint (repaint ?x ?old-colour ?new-colour)
  (variables ?x ?old-colour ?new-colour)
  (constraints
    (world-state condition (colour ?x) = ?old-colour)
    (world-state effect (colour ?x) = ?new-colour)))

(refinement resize (resize ?x ?old-size ?new-size)
  (variables ?x ?old-size ?new-size)
  (constraints
    (world-state condition (size ?x) = ?old-size)
    (world-state effect (size ?x) = ?new-size)))

;;; End
