/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Jan 30 01:24:00 2003 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.util.xml;

import ix.util.*;

/**
 * Thrown to indicate a problem converting to or from XML.
 */
public class XMLException extends RuntimeException {

    /**
     * Constructs an exception contaning the specified message.
     */
    public XMLException(String message) {
	super(message);
    }

    /**
     * Constructs an exception with a description of the reason
     * as its message.
     *
     * @see Debug#describeException(Throwable)
     */
    public XMLException(Throwable reason) {
	super(Debug.describeException(reason));
    }

    /**
     * Constructs an exception with a message containing the specified
     * message followed by " because " followed by a description of the
     * reason exception.
     *
     * @see Debug#describeException(Throwable)
     */
    public XMLException(String message, Throwable reason) {
	super(message + " because " + Debug.describeException(reason));
    }

}
