/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Mar 13 03:45:12 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.xml;

import org.jdom.*;

/**
 * XML that can be embedded in objects that can be translated to
 * or from XML.  The root element of these objects is left as-is
 * by an {@link XMLTranslator}.
 */
public class LiteralDocument {

    protected Element rootElement;

    public LiteralDocument() {}

    public LiteralDocument(Element rootElement) {
	this.rootElement = rootElement;
    }

    public Element getRootElement() {
	return rootElement;
    }

    public void setRootElement(Element rootElement) {
	this.rootElement = rootElement;
    }

}
