/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Oct 31 12:49:12 2007 by Jeff Dalton
 * Copyright: (c) 2003, 2004, 2007, AIAI, University of Edinburgh
 */

package ix.util.xml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.*;

import ix.util.*;
import ix.util.lisp.*;

/**
 * Convenient base class for {@link FileSyntax}es.
 */
public abstract class AbstractFileSyntax implements FileSyntax {

    public static final List ANY_CLASS =
	Collections.singletonList(Object.class);

    public boolean isAvailable() {
	return true;
    }

    public boolean canRead() {
	return false;
    }

    public boolean canWrite() {
	return false;
    }

    public List readableClasses() {
	return ANY_CLASS;
    }

    public List writableClasses() {
	return ANY_CLASS;
    }

    public Object readObject(URL url) throws IOException {
	throw new UnsupportedOperationException
	    ("Cannot read " + getFileTypeDescription());
    }

    public void writeObject(Object obj, File file) throws IOException {
	throw new UnsupportedOperationException
	    ("Cannot write " + getFileTypeDescription());
    }

    public String toString() {
	return Strings.afterLast(".", getClass().getName())
	    + "[" + getFileTypeDescription() + " " + getFileTypes()
	    + "]";
    }

    protected boolean existsClass(String className) {
	try {
	    Class c = Class.forName(className);
	    return true;
	}
	// /\/: Sun's javadoc for Class.forName says a ClassNotFoundException
	// is thrown, but NoClassDefFoundError occurs instead.
	catch (ClassNotFoundException e) {
	    return false;
	}
	catch (NoClassDefFoundError e) {
	    return false;
	}
	catch (Throwable t) {
	    Debug.displayException(t);
	    return false;
	}
    }

    protected Object makeInstance(String className) {
	// The required class may not be available, and we want to
	// avoid needing it for compilation.  /\/
	try {
	    Class c = Class.forName(className);
	    return Util.makeInstance(c);
	}
	catch (ClassNotFoundException e) {
	    throw new UnsupportedOperationException
		("This agent cannot handle " + getFileTypeDescription());
	}
    }

}
