/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Sep 28 17:55:25 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.reflect;

/**
 * Converts "atomic" objects to and from strings.  Typically, one
 * of these is tied to a class by a {@link ClassSyntax}.
 */
public interface Stringer {

    /**
     * Returns a textual representation of the object.
     */
    public String toString(Object obj);


    /**
     * Constructs an object from a textual representation.
     * It does not necessarily return a new object each time.
     */
    public Object fromString(String text);


    /**
     * Returns the name of the XML Schema datatype for the
     * textual representations returned by this object.
     * The value should be a simple name, such as <tt>"dateTime"</tt>,
     * not a full URL.
     *
     * @see <a href="http://www.w3.org/TR/xmlschema-2/">XML Sxchema
     *   Part 2: Datatypes</a>
     */
    public String xmlSchemaDatatype();

}
