/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Mar 13 03:44:24 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.reflect;

import java.util.*;

import ix.util.xml.LiteralDocument;

/**
 * Provides methods for the principal {@link ClassDescr} cases
 * when visiting an instance of the corresponding class.
 *
 * @see ClassDescr#visitObject(Object, ObjectVisitor).
 * @see ObjectMapper
 */
public interface ObjectVisitor {

    // The class is one returned by instance.getClass() and so cannot
    // be an interface.

    public void visitPrimitive(Object obj, ClassDescr cd);

    public void visitList(List list, ClassDescr cd);

    public void visitSet(Set set, ClassDescr cd);

    public void visitMap(Map map, ClassDescr cd);

    public void visitStruct(Object struct, ClassDescr cd);

    public void visitXML(LiteralDocument xml, ClassDescr cd);

}

// Issues:
// * Unlike in ClassVistor, the List, Set, and Map cases do not
//   pass the element, key, or value classes, because they would
//   usually be ignored and can be obtained from the ClassDescr
//   if they're wanted.
