/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Aug 17 03:03:14 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.reflect;

import java.lang.reflect.*;
import java.util.*;

import ix.util.*;

/**
 * A view of class-subclass relationships.
 */
public class InheritanceTree {

    Map classToSuperclass = new HashMap();
    MultiMap classToSubclasses = new MultiHashMap();

    List relevantClasses;

    public InheritanceTree(List relevantClasses) {
	this.relevantClasses = relevantClasses;
	assignRelevantSuperclasses(relevantClasses);
    }

    public Class getSuperclass(Class c) {
	return (Class)classToSuperclass.get(c);
    }

    public List getSubclasses(Class c) {
	return (List)classToSubclasses.get(c);
    }

    public void clear() {
	relevantClasses = null;
	classToSuperclass.clear();
	classToSubclasses.clear();
    }

    protected void assignRelevantSuperclasses(List classes) {
	Set classSet = new HashSet(classes);
	for (Iterator i = classes.iterator(); i.hasNext();) {
	    Class c = (Class)i.next();
	    Class sup = c.getSuperclass();
	    if (sup != null && classSet.contains(sup)) {
		addSubclass(sup, c);
	    }
	}
    }

    protected void addSubclass(Class superclass, Class subclass) {
	classToSubclasses.addValue(superclass, subclass);
	classToSuperclass.put(subclass, superclass);
    }

    public String toString() {
	return "InheritanceTree[classToSuperclass=" + classToSuperclass + "]";
    }

}

// Issues:
// * Work with classes or class-descrtiptions?
// * Keep track of interface implementations?
