/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Mar  9 17:14:38 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.reflect;

/**
 * An object called to visit a field when examining class and field
 * descriptions.
 *
 * @see ClassDescr#visitFields(FieldVisitor)
 */
public interface FieldVisitor {

    /**
     * Visit the specified field in the specified class
     *
     * @param cd  the class that contains the field
     * @param fd  the field
     */
    public void visitField(ClassDescr cd, FieldDescr fd);

}
