/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Feb 21 22:50:42 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.reflect;

import java.lang.reflect.*;
import java.util.*;

import ix.util.*;

/**
 * Maps an external or internal (Java) name to a {@link FieldDescr}.
 * Used in {@link ClassDescr}s.
 */
public class FieldMap {

    protected Map javaNameToField = new HashMap();
    protected Map externalNameToField = new HashMap();
    protected List fields = new LinkedList();

    public FieldMap() {}

    public void add(FieldDescr fd) {
	javaNameToField.put(fd.getName(), fd);
	externalNameToField.put(fd.getExternalName(),fd);
	fields.add(fd);
    }

    public void remove(FieldDescr fd) {
	javaNameToField.remove(fd.getName());
	externalNameToField.remove(fd.getExternalName());
	fields.remove(fd);
    }

    FieldDescr fieldForName(String name) {
	return (FieldDescr)javaNameToField.get(name);
    }

    FieldDescr fieldForExternalName(String name) {
	return (FieldDescr)externalNameToField.get(name);
    }

    List getFields() {
	return fields;
    }

}
