/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Apr  7 15:47:49 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.util.lisp;

import java.io.InputStream;
import java.io.Reader;

/**
 * A LispReader for reading Lisp source code.  It differs from an
 * ordinary LispReader by treating single quote as an abbreviation
 * for <tt>quote</tt>, so that <b>'</b><i>x</i> is read as
 * <tt>(quote <i>x</i>)</tt>.
 */
public class LispProgramReader extends LispReader {

    { singleQuoteIsMacro = true; }

    public LispProgramReader(LispTokenizer tk) {
	super(tk);
    }

    public LispProgramReader(InputStream is) {
	super(is);
    }

    public LispProgramReader(Reader r) {
	super(r);
    }

    public LispProgramReader(String s) {
	super(s);
    }

}
