/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Apr 10 20:42:11 2004 by Jeff Dalton
 */

package ix.util.lisp;

import java.util.*;

/**
 * An implementation of ListIterator for LLists.
 */
public class LListListIterator extends LListIterator implements ListIterator {

    // Inherited:
    // protected LList at = null;	// for the next next()

    protected LList list = null;
    protected int index = 0;		// 0-origin
    protected Cons setPoint = null; 	// annoying that this is needed /\/

    public LListListIterator(LList list) {
	super(list);
	this.list = list;
    }

    public LListListIterator(LList list, int start) {
	super(list);
	this.list = list;
	if (start < 0)
	    throw new IndexOutOfBoundsException();
	while (at != Lisp.NIL && index < start) {
	    at = at.cdr();
	    index++;
	}
	if (index != start)		// list too short
	    throw new IndexOutOfBoundsException();
    }

    public LListListIterator(LListListIterator i) {
	super(i);
	this.list = i.list;
	this.index = i.index;
	this.setPoint = i.setPoint;
    }

    public boolean hasNext() {
	return at != Lisp.NIL;
    }

    public Object next() {
	if (at != Lisp.NIL) {
	    Object elt = at.car();
	    setPoint = (Cons)at;
	    index++;
	    at = at.cdr();
	    return elt;
	}
	else
	    throw new NoSuchElementException("at end of LList");
    }

    public boolean hasPrevious() {
	return index > 0;
    }

    public Object previous() {
	if (index > 0) {
	    index--;
	    // at = list.drop(index);
	    at = at == Lisp.NIL
		? list.lastCons()
		: theCdrBefore((Cons)at, list);
	    setPoint = (Cons)at;
	    return at.car();
	}
	else
	    throw new NoSuchElementException("at start of LList");
    }

    protected static final Cons theCdrBefore(Cons tail, LList list) {
	for (LList at = list; at != Lisp.NIL; at = at.cdr()) {
	    if (at.cdr() == tail)
		return (Cons)at;
	}
	throw new IllegalArgumentException("Can't find list tail");
    }

    public int nextIndex() {
	return index;
    }

    public int previousIndex() {
	return index - 1;
    }

    public void remove() {
	throw new UnsupportedOperationException("Cannot remove from an LList");
    }

    public void set(Object o) {
	if (setPoint == null)
	    throw new IllegalStateException("set without next or previous");
	else
	    setPoint.setCar(o);
    }

    public void add(Object o) {
	throw new UnsupportedOperationException("Cannot add to an LList");
    }

}
