/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Aug 22 22:40:42 2007 by Jeff Dalton
 * Copyright: (c) 2001, 2004, 2007, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * A context-holding strategy that associates context-holders with
 * threads.  The holder for a thread is initially null and so must
 * be explicitly set.  More than one thread may be given the same
 * context-holder.
 */
public class ThreadLocalHoldingStrategy extends ContextHoldingStrategy {

    WeakHashMap knownHolders = new WeakHashMap();

    ThreadLocal threadContextHolder;

    public ThreadLocalHoldingStrategy() {
	threadContextHolder = new ThreadLocal();
    }

    public synchronized ContextHolder getContextHolder() {
	return (ContextHolder)threadContextHolder.get();
    }

    public synchronized void setContextHolder(ContextHolder h) {
	knownHolders.put(h, null);
	threadContextHolder.set(h);
    }

    public synchronized void clearContexts() {
	for (Iterator i = knownHolders.entrySet().iterator(); i.hasNext();) {
	    ContextHolder h = (ContextHolder)i.next();
	    h.setContext(Context.rootContext);
	}
    }

}
