/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Sep 15 19:05:11 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2004, 2006, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * An object that contains a single context-dependent value.
 */
public class ContextValue<T> {

    protected ContextHolder holder;
    protected ContextLink link;

    public ContextValue(T rootValue) {
	this(Context.getContextHolder(), rootValue);
    }

    public ContextValue(ContextHolder holder, T rootValue) {
	this.holder = holder;
	this.link = new ContextLink(rootValue);
    }

    public T get() {
	return (T)Context.getInContext(link, holder.getContext());
    }

    public void set(T new_value) {
	Context.setInContext(link, holder.getContext(), new_value);
    }

}
