/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Apr 24 14:51:43 2004 by Jeff Dalton
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * An object that contains a single context-dependent String value.
 */
public class ContextString {

    ContextHolder holder;
    ContextLink link;

    public ContextString(String rootValue) {
	this(Context.getContextHolder(),
	     rootValue);
    }

    public ContextString(ContextHolder holder, String rootValue) {
	this.holder = holder;
	this.link = new ContextLink(rootValue);
    }

    public String get() {
	return (String)Context.getInContext(link, holder.getContext());
    }

    public void set(String new_value) {
	Context.setInContext(link, holder.getContext(), new_value);
    }

}
