/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Apr 24 14:51:04 2004 by Jeff Dalton
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * An object that contains a single context-dependent long value.
 */
public class ContextLong {

    ContextHolder holder;
    ContextLink link;

    public ContextLong(long rootValue) {
	this(Context.getContextHolder(),
	     rootValue);
    }

    public ContextLong(ContextHolder holder, long rootValue) {
	this.holder = holder;
	this.link = new ContextLink(new Long(rootValue));
    }

    public long get() {
	return ((Long)Context.getInContext(link, holder.getContext()))
	            .longValue();
    }

    public void set(long new_value) {
	Context.setInContext(link,
			     holder.getContext(),
			     new Long(new_value));
    }

}
