/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Mar  6 05:09:53 2005 by Jeff Dalton
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * An object that contains a single context-dependent int value.
 */
public class ContextInt {

    ContextHolder holder;
    ContextLink link;

    public ContextInt(int rootValue) {
	this(Context.getContextHolder(),
	     rootValue);
    }

    public ContextInt(ContextHolder holder, int rootValue) {
	this.holder = holder;
	this.link = new ContextLink(new Integer(rootValue));
    }

    public int get() {
	return ((Integer)Context.getInContext(link, holder.getContext()))
	            .intValue();
    }

    public void set(int new_value) {
	Context.setInContext(link,
			     holder.getContext(),
			     new Integer(new_value));
    }

    /** Increment by the indicated amount, then return the new value. */
    public int add(int incr) {
	int i = get() + incr;
	set(i);
	return i;
    }

    /** Increment then return the new value.  Like <tt>++i</tt>. */
    public int incrBefore() {
	int i = get() + 1;
	set(i);
	return i;
    }

    /** Increment then return the old value.  Like <tt>i++</ii>. */
    public int incrAfter() {
	int i = get();
	set(i + 1);
	return i;
    }

}
