/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Apr 26 22:09:01 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

import ix.util.*;
import ix.util.lisp.*;

/**
 * Context-dependent name and ID generator a la gensym.
 *
 * <p>Compare {@link Gensym}.
 */
public class ContextGensym {

    private ContextGensym() { }

    public static class Generator {

	protected Map counters;

	public Generator() { this(Context.getContextHolder()); }

	public Generator(ContextHolder holder) {
	    this.counters = new ContextHashMap(holder);
	}

	public String nextString(String base) {
	    Long count = (Long)counters.get(base);
	    if (count == null) {
		count = new Long(0);
		counters.put(base, count);
	    }
	    long c = count.longValue();
	    counters.put(base, new Long(c + 1));
	    return base + "-" + c;
	}

	public Name nextName(String base) {
	    return Name.valueOf(nextString(base));
	}

	public Symbol nextSymbol(String base) {
	    return Symbol.intern(nextString(base));
	}

	public Symbol nextNewSymbol(String base) {
	    throw new UnsupportedOperationException
		("nextNewSymbol is not available for ContextGensym");
	}

    }

}
