/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu May 11 02:51:51 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.util;

import java.io.Serializable;

/**
 * Objects used just to be distinct from other objects.
 * It's often better to use an Object, rather than null,
 * to indicate "not found" or similar, because so many things
 * can produce a null that it can be difficult to find what
 * produced one when something goes wrong.  UniqueObjects
 * have a name that appears in output which is intended to
 * make them easier to identify than a plain Object would be.
 * Each UniqueObject also has a number that appears along with
 * the name in the toString() result.
 */
public class UniqueObject implements Serializable {

    private static int count = 0;

    protected String name;

    public UniqueObject(String name) {
	this.name = "#<" + name + "-" + count++ + ">";
    }

    public UniqueObject() {
	this("UniqueObject");
    }

    public String getName() {
	return name;
    }

    public void setName(String name) {
	if (name == null)
	    this.name = name;
	else
	    throw new IllegalStateException
		("Attempt to change the name of " + this);
    }

    public String toString() {
	return name;
    }

}

// Issues:
// * Need to ensure "uniqueness" if serialized and deserialized.
