/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Jan 24 16:14:24 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

/**
 * A thread that processes a message queue.
 *
 * @see MessageQueue
 */
public abstract class TransferThread extends CatchingThread {

    protected MessageQueue queue = new MessageQueue();

    public TransferThread() { }

    /**
     * Enqueue the object for processing
     */
    public void take(Object message) {
	queue.send(message);
    }

    /**
     * Loops taking a message from the queue and calling
     * <code>handle(message)</code>.
     */
    public void innerRun() {
	while (true) {
	    handle(queue.nextMessage());
	}
    }

    /**
     * Called to process the message in whatever way is desired.
     */
    public abstract void handle(Object message);

}


