/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Apr 20 14:33:22 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

import ix.util.lisp.*;

/**
 * DAG topological sort, returning ancestors before descendents.
 *
 * <p>You should make a new sorter each time.</p>
 */
public abstract class TopologicalSorter {

    static final Object START = new Object();
    static final Object FINISH = new Object();
    final Map marks = new HashMap();
    final LListCollector result = new LListCollector();

    public TopologicalSorter() { }

    public List sort(Collection roots) {
	walk(roots);
	return result.contents();
    }

    protected void walk(Collection items) {
	for (Iterator i = items.iterator(); i.hasNext();) {
	    Object at = i.next();
	    Object mark = marks.get(at);
	    if (mark == START)
		throw new ConsistencyException("Cycle at", at);
	    else if (mark == FINISH)
		;		// already visited
	    else {
		marks.put(at, START);
		walk(getChildren(at));
		result.pushElement(at);
		marks.put(at, FINISH);
	    }
	}
    }

    protected abstract Collection getChildren(Object node);

}
