/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb 15 23:21:38 2006 by Jeff Dalton
 * Copyright: (c) 2002, 2006, AIAI, University of Edinburgh
 */

package ix.util;

import ix.util.reflect.Stringer;
import ix.util.reflect.ClassSyntax;

/**
 * Tagging interface for objects that have a straightforward representation
 * as Strings.  The <code><i>obj</i>.ToString()</code> method should return
 * that representation for <i>obj</i>, and the class should provide a
 * static <code>valueOf(String)</code> method for conversion in the
 * opposite direction.  Alternatively, conversion can be handled
 * by a {@link Stringer} defined in a {@link ClassSyntax}.
 *
 * @see ClassSyntax#setStringer(Class, Stringer)
 */
public interface SemiPrimitive {

    // No methods.

}
