/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Nov 24 13:40:21 2007 by Jeff Dalton
 * Copyright: (c) 2007, AIAI, University of Edinburgh
 */

package ix.util;

import java.io.*;
import java.util.*;

/**
 * An unchecked exception used to wrap IOExceptions when they're
 * rethrown.  This is a separate subclass because it's so common
 * a case and may call for different handling.
 */
public class RethrownIOException extends RethrownException {

    /**
     * Constructs an exception with a description of the cause
     * as its message.
     *
     * @see Debug#describeException(Throwable)
     */
    public RethrownIOException(Throwable cause) {
	super(cause);
    }

    /**
     * Constructs an exception with the specified cause and a message
     * formed by concatenating the prefix, followed by a space, to the
     * result of calling {@link Debug#describeException(Throwable)}
     * on the cause.
     */
    public RethrownIOException(String messagePrefix, Throwable cause) {
	super(messagePrefix, cause);
    }

}
